/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.util.ArrayList;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.TransactionTable;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.shared.common.error.StandardException;

public class XactXAResourceManager
implements XAResourceManager {
    private TransactionTable transaction_table;
    private RawStoreFactory rsf;

    public XactXAResourceManager(RawStoreFactory rawStoreFactory, TransactionTable transactionTable) {
        this.rsf = rawStoreFactory;
        this.transaction_table = transactionTable;
    }

    @Override
    public void commit(ContextManager contextManager, Xid xid, boolean bl) throws StandardException {
        Transaction transaction = this.rsf.findUserTransaction(contextManager, "UserTransaction");
        if (transaction == null) {
            throw StandardException.newException((String)"XSAX0.S", (Object[])new Object[0]);
        }
        transaction.xa_commit(bl);
    }

    @Override
    public ContextManager find(Xid xid) {
        return this.transaction_table.findTransactionContextByGlobalId(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()));
    }

    @Override
    public void forget(ContextManager contextManager, Xid xid) throws StandardException {
        Transaction transaction = this.rsf.findUserTransaction(contextManager, "UserTransaction");
        throw StandardException.newException((String)"XSAX0.S", (Object[])new Object[0]);
    }

    @Override
    public Xid[] recover(int n) throws StandardException {
        Xid[] xidArray;
        if ((n & 0x1000000) != 0) {
            final ArrayList arrayList = new ArrayList();
            TransactionTable.EntryVisitor entryVisitor = new TransactionTable.EntryVisitor(){

                @Override
                public boolean visit(TransactionTableEntry transactionTableEntry) {
                    Xact xact = transactionTableEntry.getXact();
                    if (xact.isPrepared()) {
                        GlobalXactId globalXactId = (GlobalXactId)xact.getGlobalId();
                        arrayList.add(new XAXactId(globalXactId.getFormat_Id(), globalXactId.getGlobalTransactionId(), globalXactId.getBranchQualifier()));
                    }
                    return true;
                }
            };
            this.transaction_table.visitEntries(entryVisitor);
            xidArray = new XAXactId[arrayList.size()];
            xidArray = (XAXactId[])arrayList.toArray(xidArray);
        } else {
            xidArray = new XAXactId[]{};
        }
        return xidArray;
    }

    @Override
    public void rollback(ContextManager contextManager, Xid xid) throws StandardException {
        Transaction transaction = this.rsf.findUserTransaction(contextManager, "UserTransaction");
        if (transaction == null) {
            throw StandardException.newException((String)"XSAX0.S", (Object[])new Object[0]);
        }
        transaction.xa_rollback();
    }
}

