/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger.sender;

import java.util.Deque;
import java.util.LinkedList;
import org.fluentd.logger.sender.Reconnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantDelayReconnector
implements Reconnector {
    private static final Logger LOG = LoggerFactory.getLogger(ConstantDelayReconnector.class);
    private double wait = 50.0;
    private static final int MAX_ERROR_HISTORY_SIZE = 100;
    private Deque<Long> errorHistory = new LinkedList<Long>();

    public ConstantDelayReconnector() {
        this.errorHistory = new LinkedList<Long>();
    }

    public ConstantDelayReconnector(int wait) {
        this.wait = wait;
        this.errorHistory = new LinkedList<Long>();
    }

    @Override
    public void addErrorHistory(long timestamp) {
        this.errorHistory.addLast(timestamp);
        if (this.errorHistory.size() > 100) {
            this.errorHistory.removeFirst();
        }
    }

    @Override
    public boolean isErrorHistoryEmpty() {
        return this.errorHistory.isEmpty();
    }

    @Override
    public void clearErrorHistory() {
        this.errorHistory.clear();
    }

    @Override
    public boolean enableReconnection(long timestamp) {
        return this.errorHistory.isEmpty() || (double)(timestamp - this.errorHistory.getLast()) >= this.wait;
    }
}

