/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger;

import java.util.HashMap;
import java.util.Map;
import org.fluentd.logger.FluentLoggerFactory;
import org.fluentd.logger.sender.Sender;

public class FluentLogger {
    private static FluentLoggerFactory factory = new FluentLoggerFactory();
    protected String tagPrefix;
    protected Sender sender;

    public static FluentLogger getLogger(String tag) {
        return factory.getLogger(tag, "localhost", 24224);
    }

    public static FluentLogger getLogger(String tag, String host, int port) {
        return factory.getLogger(tag, host, port, 3000, 0x100000);
    }

    public static synchronized FluentLogger getLogger(String tag, String host, int port, int timeout, int bufferCapacity) {
        return factory.getLogger(tag, host, port, timeout, bufferCapacity);
    }

    static Map<String, FluentLogger> getLoggers() {
        return factory.getLoggers();
    }

    public static synchronized void closeAll() {
        factory.closeAll();
    }

    public static synchronized void flushAll() {
        factory.flushAll();
    }

    protected FluentLogger() {
    }

    protected FluentLogger(String tag, Sender sender) {
        this.tagPrefix = tag;
        this.sender = sender;
    }

    public boolean log(String label, String key, Object value) {
        return this.log(label, key, value, 0L);
    }

    public boolean log(String label, String key, Object value, long timestamp) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(key, value);
        return this.log(label, data, timestamp);
    }

    public boolean log(String label, Map<String, Object> data) {
        return this.log(label, data, 0L);
    }

    public boolean log(String label, Map<String, Object> data, long timestamp) {
        if (timestamp != 0L) {
            return this.sender.emit(this.tagPrefix + "." + label, timestamp, data);
        }
        return this.sender.emit(this.tagPrefix + "." + label, data);
    }

    public void flush() {
        this.sender.flush();
    }

    public void close() {
        if (this.sender != null) {
            this.sender.close();
            this.sender = null;
        }
    }

    public String getName() {
        return String.format("%s_%s", this.tagPrefix, this.sender.getName());
    }

    public String toString() {
        return String.format("%s{tagPrefix=%s,sender=%s}", this.getClass().getName(), this.tagPrefix, this.sender.toString());
    }

    public void finalize() {
        if (this.sender != null) {
            this.sender.close();
        }
    }
}

