/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.rest.app;

import java.util.ArrayList;
import java.util.List;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.GroupRepresentation;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.idm.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/admin/groups"})
public class IdmGroupsResource {
    @Autowired
    private GroupService groupService;

    @GetMapping
    public List<GroupRepresentation> getGroups(@RequestParam(required=false) String filter) {
        ArrayList<GroupRepresentation> result = new ArrayList<GroupRepresentation>();
        for (Group group : this.groupService.getGroups(filter)) {
            result.add(new GroupRepresentation(group));
        }
        return result;
    }

    @GetMapping(value={"/{groupId}"})
    public GroupRepresentation getGroup(@PathVariable String groupId) {
        return new GroupRepresentation(this.groupService.getGroup(groupId));
    }

    @GetMapping(value={"/{groupId}/users"})
    public ResultListDataRepresentation getGroupUsers(@PathVariable String groupId, @RequestParam(required=false) String filter, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer pageSize) {
        List users = this.groupService.getGroupUsers(groupId, filter, page, pageSize);
        ArrayList<UserRepresentation> userRepresentations = new ArrayList<UserRepresentation>(users.size());
        for (User user : users) {
            userRepresentations.add(new UserRepresentation(user));
        }
        ResultListDataRepresentation resultListDataRepresentation = new ResultListDataRepresentation(userRepresentations);
        resultListDataRepresentation.setStart(Integer.valueOf(page * pageSize));
        resultListDataRepresentation.setSize(Integer.valueOf(userRepresentations.size()));
        resultListDataRepresentation.setTotal(Long.valueOf(this.groupService.countTotalGroupUsers(groupId, filter, page, pageSize)));
        return resultListDataRepresentation;
    }

    @PostMapping
    public GroupRepresentation createNewGroup(@RequestBody GroupRepresentation groupRepresentation) {
        return new GroupRepresentation(this.groupService.createNewGroup(groupRepresentation.getId(), groupRepresentation.getName(), groupRepresentation.getType()));
    }

    @PutMapping(value={"/{groupId}"})
    public GroupRepresentation updateGroup(@PathVariable String groupId, @RequestBody GroupRepresentation groupRepresentation) {
        return new GroupRepresentation(this.groupService.updateGroupName(groupId, groupRepresentation.getName()));
    }

    @ResponseStatus(value=HttpStatus.OK)
    @DeleteMapping(value={"/{groupId}"})
    public void deleteGroup(@PathVariable String groupId) {
        this.groupService.deleteGroup(groupId);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"/{groupId}/members/{userId}"})
    public void addGroupMember(@PathVariable String groupId, @PathVariable String userId) {
        this.groupService.addGroupMember(groupId, userId);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @DeleteMapping(value={"/{groupId}/members/{userId}"})
    public void deleteGroupMember(@PathVariable String groupId, @PathVariable String userId) {
        this.groupService.deleteGroupMember(groupId, userId);
    }
}

