/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.rest.api;

import java.util.ArrayList;
import java.util.List;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.GroupRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.idm.model.UserInformation;
import org.flowable.ui.idm.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ApiUsersResource {
    @Autowired
    protected UserService userService;

    @GetMapping(value={"/users/{userId}"}, produces={"application/json"})
    public UserRepresentation getUserInformation(@PathVariable String userId) {
        UserInformation userInformation = this.userService.getUserInformation(userId);
        if (userInformation != null) {
            UserRepresentation userRepresentation = new UserRepresentation(userInformation.getUser());
            if (userInformation.getGroups() != null) {
                for (Group group : userInformation.getGroups()) {
                    userRepresentation.getGroups().add(new GroupRepresentation(group));
                }
            }
            if (userInformation.getPrivileges() != null) {
                for (String privilege : userInformation.getPrivileges()) {
                    userRepresentation.getPrivileges().add(privilege);
                }
            }
            return userRepresentation;
        }
        throw new NotFoundException();
    }

    @GetMapping(value={"/users"}, produces={"application/json"})
    public List<UserRepresentation> findUsersByFilter(@RequestParam(value="filter") String filter) {
        List users = this.userService.getUsers(filter, null, null);
        ArrayList<UserRepresentation> result = new ArrayList<UserRepresentation>();
        for (User user : users) {
            result.add(new UserRepresentation(user));
        }
        return result;
    }
}

