/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.api.UserQuery;
import org.flowable.spring.boot.ldap.FlowableLdapProperties;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.idm.cache.UserCache;
import org.flowable.ui.idm.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.transaction.annotation.Transactional;

public class UserDetailsService
implements org.springframework.security.core.userdetails.UserDetailsService {
    @Autowired
    protected UserCache userCache;
    @Autowired
    protected IdmIdentityService identityService;
    @Autowired
    protected UserService userService;
    @Autowired(required=false)
    protected FlowableLdapProperties ldapProperties;
    protected long userValidityPeriod;

    @Transactional
    public UserDetails loadUserByUsername(String login) {
        String actualLogin = login;
        org.flowable.idm.api.User userFromDatabase = null;
        if (this.ldapProperties == null || !this.ldapProperties.isEnabled()) {
            actualLogin = login.toLowerCase();
            userFromDatabase = (org.flowable.idm.api.User)((UserQuery)this.identityService.createUserQuery().userIdIgnoreCase(actualLogin)).singleResult();
        } else {
            userFromDatabase = (org.flowable.idm.api.User)((UserQuery)this.identityService.createUserQuery().userId(actualLogin)).singleResult();
        }
        if (userFromDatabase == null) {
            throw new UsernameNotFoundException("User " + actualLogin + " was not found in the database");
        }
        String userId = userFromDatabase.getId();
        List userPrivileges = this.identityService.createPrivilegeQuery().userId(userId).list();
        HashSet<Object> grantedAuthorities = new HashSet<Object>();
        for (Privilege userPrivilege : userPrivileges) {
            grantedAuthorities.add(new SimpleGrantedAuthority(userPrivilege.getName()));
        }
        List groups = this.identityService.createGroupQuery().groupMember(userId).list();
        if (!groups.isEmpty()) {
            ArrayList<String> groupIds = new ArrayList<String>(groups.size());
            for (Group group : groups) {
                grantedAuthorities.add(SecurityUtils.createGroupAuthority((String)group.getId()));
                groupIds.add(group.getId());
            }
            List groupPrivileges = this.identityService.createPrivilegeQuery().groupIds(groupIds).list();
            for (Privilege groupPrivilege : groupPrivileges) {
                grantedAuthorities.add(new SimpleGrantedAuthority(groupPrivilege.getName()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)userFromDatabase.getTenantId())) {
            grantedAuthorities.add(SecurityUtils.createTenantAuthority((String)userFromDatabase.getTenantId()));
        }
        this.userCache.putUser(userFromDatabase.getId(), new UserCache.CachedUser(userFromDatabase, grantedAuthorities));
        return User.withUsername((String)userId).password((String)StringUtils.defaultIfBlank((CharSequence)userFromDatabase.getPassword(), (CharSequence)"")).authorities(grantedAuthorities).build();
    }

    public void setUserValidityPeriod(long userValidityPeriod) {
        this.userValidityPeriod = userValidityPeriod;
    }
}

