/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.service.idm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.flowable.ui.common.model.RemoteGroup;
import org.flowable.ui.common.model.RemoteToken;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class RemoteIdmServiceImpl
implements RemoteIdmService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIdmServiceImpl.class);
    @Autowired
    protected ObjectMapper objectMapper;
    protected String url;
    protected String adminUser;
    protected String adminPassword;

    public RemoteIdmServiceImpl(FlowableCommonAppProperties properties) {
        this.url = properties.determineIdmAppUrl();
        this.adminUser = properties.getIdmAdmin().getUser();
        Assert.hasText((String)this.adminUser, (String)"Admin user must not be empty");
        this.adminPassword = properties.getIdmAdmin().getPassword();
        Assert.hasText((String)this.adminUser, (String)"Admin user password should not be empty");
    }

    @Override
    public RemoteUser authenticateUser(String username, String password) {
        JsonNode json = this.callRemoteIdmService(this.url + "api/idm/users/" + this.encode(username), username, password);
        if (json != null) {
            return this.parseUserInfo(json);
        }
        return null;
    }

    @Override
    public RemoteToken getToken(String tokenValue) {
        JsonNode json = this.callRemoteIdmService(this.url + "api/idm/tokens/" + this.encode(tokenValue), this.adminUser, this.adminPassword);
        if (json != null) {
            RemoteToken token = new RemoteToken();
            token.setId(json.get("id").asText());
            token.setValue(json.get("value").asText());
            token.setUserId(json.get("userId").asText());
            return token;
        }
        return null;
    }

    @Override
    public RemoteUser getUser(String userId) {
        JsonNode json = this.callRemoteIdmService(this.url + "api/idm/users/" + this.encode(userId), this.adminUser, this.adminPassword);
        if (json != null) {
            return this.parseUserInfo(json);
        }
        return null;
    }

    @Override
    public List<RemoteUser> findUsersByNameFilter(String filter) {
        JsonNode json = this.callRemoteIdmService(this.url + "api/idm/users?filter=" + this.encode(filter), this.adminUser, this.adminPassword);
        if (json != null) {
            return this.parseUsersInfo(json);
        }
        return new ArrayList<RemoteUser>();
    }

    @Override
    public List<RemoteUser> findUsersByGroup(String groupId) {
        JsonNode json = this.callRemoteIdmService(this.url + "api/idm/groups/" + this.encode(groupId) + "/users", this.adminUser, this.adminPassword);
        if (json != null) {
            return this.parseUsersInfo(json);
        }
        return new ArrayList<RemoteUser>();
    }

    @Override
    public RemoteGroup getGroup(String groupId) {
        JsonNode json = this.callRemoteIdmService(this.url + "api/idm/groups/" + this.encode(groupId), this.adminUser, this.adminPassword);
        if (json != null) {
            return this.parseGroupInfo(json);
        }
        return null;
    }

    @Override
    public List<RemoteGroup> findGroupsByNameFilter(String filter) {
        JsonNode json = this.callRemoteIdmService(this.url + "api/idm/groups?filter=" + this.encode(filter), this.adminUser, this.adminPassword);
        if (json != null) {
            return this.parseGroupsInfo(json);
        }
        return new ArrayList<RemoteGroup>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonNode callRemoteIdmService(String url, String username, String password) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Authorization", "Basic " + new String(Base64.getEncoder().encode((username + ":" + password).getBytes(Charset.forName("UTF-8")))));
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            sslsf = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        catch (Exception e) {
            LOGGER.warn("Could not configure SSL for http client", (Throwable)e);
        }
        CloseableHttpClient client = clientBuilder.build();
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                JsonNode jsonNode = this.objectMapper.readTree(response.getEntity().getContent());
                return jsonNode;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while getting token", (Throwable)e);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Exception while closing http client", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected List<RemoteUser> parseUsersInfo(JsonNode json) {
        ArrayList<RemoteUser> result = new ArrayList<RemoteUser>();
        if (json != null && json.isArray()) {
            ArrayNode array = (ArrayNode)json;
            for (JsonNode userJson : array) {
                result.add(this.parseUserInfo(userJson));
            }
        }
        return result;
    }

    protected RemoteUser parseUserInfo(JsonNode json) {
        RemoteUser user = new RemoteUser();
        user.setId(json.get("id").asText());
        user.setFirstName(json.get("firstName").asText());
        user.setLastName(json.get("lastName").asText());
        if (json.has("displayName") && !json.get("displayName").isNull()) {
            user.setDisplayName(json.get("displayName").asText());
        }
        user.setEmail(json.get("email").asText());
        user.setFullName(json.get("fullName").asText());
        if (json.has("tenantId") && !json.get("tenantId").isNull()) {
            user.setTenantId(json.get("tenantId").asText());
        }
        if (json.has("groups")) {
            for (JsonNode groupNode : (ArrayNode)json.get("groups")) {
                user.getGroups().add(new RemoteGroup(groupNode.get("id").asText(), groupNode.get("name").asText()));
            }
        }
        if (json.has("privileges")) {
            for (JsonNode privilegeNode : (ArrayNode)json.get("privileges")) {
                user.getPrivileges().add(privilegeNode.asText());
            }
        }
        return user;
    }

    protected List<RemoteGroup> parseGroupsInfo(JsonNode json) {
        ArrayList<RemoteGroup> result = new ArrayList<RemoteGroup>();
        if (json != null && json.isArray()) {
            ArrayNode array = (ArrayNode)json;
            for (JsonNode userJson : array) {
                result.add(this.parseGroupInfo(userJson));
            }
        }
        return result;
    }

    protected RemoteGroup parseGroupInfo(JsonNode json) {
        RemoteGroup group = new RemoteGroup();
        group.setId(json.get("id").asText());
        group.setName(json.get("name").asText());
        return group;
    }

    protected String encode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.warn("Could not encode url param", (Throwable)e);
            return null;
        }
    }
}

