/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.FormInstanceService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormInstanceClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormInstanceClientResource.class);
    @Autowired
    protected FormInstanceService clientService;
    @Autowired
    protected ObjectMapper objectMapper;

    @GetMapping(value={"/rest/admin/form-instances/{formInstanceId}"}, produces={"application/json"})
    public JsonNode getFormInstance(HttpServletRequest request, @PathVariable String formInstanceId) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.FORM);
        return this.clientService.getFormInstance(serverConfig, formInstanceId);
    }

    @GetMapping(value={"/rest/admin/task-form-instance/{taskId}"}, produces={"application/json"})
    public JsonNode getTaskFormInstance(@PathVariable String taskId) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.FORM);
        try {
            ObjectNode bodyNode = this.objectMapper.createObjectNode();
            bodyNode.put("taskId", taskId);
            return this.clientService.getFormInstances(serverConfig, bodyNode);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting form instance for task id {}", (Object)taskId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/form-instances/{formInstanceId}/form-field-values"}, produces={"application/json"})
    public JsonNode getFormInstanceFormFieldValues(HttpServletRequest request, @PathVariable String formInstanceId) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.FORM);
        return this.clientService.getFormInstanceFormFieldValues(serverConfig, formInstanceId);
    }
}

