/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.DecisionTableService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DecisionTableClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionTableClientResource.class);
    @Autowired
    protected DecisionTableService clientService;

    @GetMapping(value={"/rest/admin/decision-tables/{decisionTableId}"}, produces={"application/json"})
    public JsonNode getDecisionTable(@PathVariable String decisionTableId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.DMN);
        try {
            return this.clientService.getDecisionTable(serverConfig, decisionTableId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting decision table {}", (Object)decisionTableId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/decision-tables/{decisionTableId}/editorJson"}, produces={"application/json"})
    public JsonNode getEditorJsonForDecisionTable(@PathVariable String decisionTableId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.DMN);
        try {
            return this.clientService.getEditorJsonForDecisionTable(serverConfig, decisionTableId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting editor json for decision table {}", (Object)decisionTableId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

