/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.CmmnJobService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmmnJobsClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnJobsClientResource.class);
    @Autowired
    protected CmmnJobService jobService;

    @GetMapping(value={"/rest/admin/cmmn-jobs"}, produces={"application/json"})
    public JsonNode listCmmnJobs(HttpServletRequest request) {
        LOGGER.debug("REST request to get a list of jobs");
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
        try {
            return this.jobService.listJobs(serverConfig, parameterMap);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting jobs", (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

