/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.CmmnJobService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmmnJobClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnJobClientResource.class);
    @Autowired
    protected CmmnJobService clientService;

    @GetMapping(value={"/rest/admin/cmmn-jobs/{jobId}"}, produces={"application/json"})
    public JsonNode getCmmnJob(@PathVariable String jobId, HttpServletRequest request) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        String jobType = request.getParameter("jobType");
        try {
            return this.clientService.getJob(serverConfig, jobId, jobType);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting job {}", (Object)jobId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @DeleteMapping(value={"/rest/admin/cmmn-jobs/{jobId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteCmmnJob(@PathVariable String jobId, HttpServletRequest request) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        String jobType = request.getParameter("jobType");
        try {
            this.clientService.deleteJob(serverConfig, jobId, jobType);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error deleting job {}", (Object)jobId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @PostMapping(value={"/rest/admin/cmmn-jobs/{jobId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void executeCmmnJob(@PathVariable String jobId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            this.clientService.executeJob(serverConfig, jobId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error executing job {}", (Object)jobId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @PostMapping(value={"/rest/admin/move-cmmn-jobs/{jobId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void moveCmmnJob(@PathVariable String jobId, HttpServletRequest request) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        String jobType = request.getParameter("jobType");
        try {
            this.clientService.moveJob(serverConfig, jobId, jobType);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error executing job {}", (Object)jobId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/cmmn-jobs/{jobId}/stacktrace"}, produces={"text/plain"})
    public String getCmmnJobStacktrace(@PathVariable String jobId, HttpServletRequest request) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        String jobType = request.getParameter("jobType");
        try {
            String trace = this.clientService.getJobStacktrace(serverConfig, jobId, jobType);
            if (trace != null) {
                trace = StringUtils.trim((String)trace);
            }
            return trace;
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting job stacktrace {}", (Object)jobId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

