/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.FormDeploymentService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/admin/form-deployments"})
public class FormDeploymentsClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDeploymentsClientResource.class);
    @Autowired
    protected FormDeploymentService clientService;

    @GetMapping(produces={"application/json"})
    public JsonNode listDeployments(HttpServletRequest request) {
        LOGGER.debug("REST request to get a list of form deployments");
        JsonNode resultNode = null;
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.FORM);
        Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
        try {
            resultNode = this.clientService.listDeployments(serverConfig, parameterMap);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting form deployments", (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
        return resultNode;
    }

    @PostMapping(produces={"application/json"})
    public JsonNode handleFileUpload(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        if (!file.isEmpty()) {
            try {
                ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.FORM);
                String fileName = file.getOriginalFilename();
                if (fileName != null && (fileName.endsWith(".form") || fileName.endsWith(".json"))) {
                    return this.clientService.uploadDeployment(serverConfig, fileName, file.getInputStream());
                }
                LOGGER.error("Invalid form deployment file name {}", (Object)fileName);
                throw new BadRequestException("Invalid file name");
            }
            catch (IOException e) {
                LOGGER.error("Error deploying form upload", (Throwable)e);
                throw new InternalServerErrorException("Could not deploy file: " + e.getMessage());
            }
        }
        LOGGER.error("No form deployment file found in request");
        throw new BadRequestException("No file found in POST body");
    }
}

