/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.EventSubscriptionService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EventSubscriptionClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventSubscriptionClientResource.class);
    @Autowired
    protected EventSubscriptionService eventSubscriptionService;

    @GetMapping(value={"/rest/admin/event-subscriptions/{eventSubscriptionId}"}, produces={"application/json"})
    public JsonNode getEventSubscription(@PathVariable String eventSubscriptionId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            return this.eventSubscriptionService.getEventSubscription(serverConfig, eventSubscriptionId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting event subscription {}", (Object)eventSubscriptionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @PostMapping(value={"/rest/admin/event-subscriptions/{eventSubscriptionId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void triggerEvent(@PathVariable String eventSubscriptionId, @RequestBody ObjectNode eventBody) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        String eventType = eventBody.get("eventType").asText();
        String eventName = eventBody.get("eventName").asText();
        if (eventBody.has("executionId") && !eventBody.get("executionId").isNull()) {
            try {
                this.eventSubscriptionService.triggerExecutionEvent(serverConfig, eventType, eventName, eventBody.get("executionId").asText());
            }
            catch (FlowableServiceException e) {
                LOGGER.error("Error triggering execution event for event subscription {}", (Object)eventSubscriptionId, (Object)e);
                throw new BadRequestException(e.getMessage());
            }
        } else if ("message".equals(eventType)) {
            try {
                String tenantId = null;
                if (eventBody.has("tenantId") && !eventBody.get("tenantId").isNull()) {
                    tenantId = eventBody.get("tenantId").asText();
                }
                this.eventSubscriptionService.triggerMessageEvent(serverConfig, eventName, tenantId);
            }
            catch (FlowableServiceException e) {
                LOGGER.error("Error triggering message event for event subscription {}", (Object)eventSubscriptionId, (Object)e);
                throw new BadRequestException(e.getMessage());
            }
        } else if ("signal".equals(eventType)) {
            try {
                this.eventSubscriptionService.triggerSignalEvent(serverConfig, eventName);
            }
            catch (FlowableServiceException e) {
                LOGGER.error("Error triggering signal event for event subscription {}", (Object)eventSubscriptionId, (Object)e);
                throw new BadRequestException(e.getMessage());
            }
        } else {
            throw new FlowableServiceException("Unsupported event type " + eventType);
        }
    }
}

