/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.Stage;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.CaseDefinitionService;
import org.flowable.ui.admin.service.engine.CaseInstanceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmmnDisplayJsonClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnDisplayJsonClientResource.class);
    @Autowired
    protected CaseDefinitionService clientService;
    @Autowired
    protected CaseInstanceService caseInstanceService;
    protected ObjectMapper objectMapper = new ObjectMapper();

    @GetMapping(value={"/rest/admin/case-definitions/{caseDefinitionId}/model-json"}, produces={"application/json"})
    public JsonNode getCaseDefinitionModelJSON(@PathVariable String caseDefinitionId) {
        ServerConfig config = this.retrieveServerConfig(EndpointType.CMMN);
        ObjectNode displayNode = this.objectMapper.createObjectNode();
        CmmnModel pojoModel = this.clientService.getCaseDefinitionModel(config, caseDefinitionId);
        if (!pojoModel.getLocationMap().isEmpty()) {
            try {
                GraphicInfo diagramInfo = new GraphicInfo();
                this.processCaseElements(pojoModel, displayNode, diagramInfo, null, null, null);
                displayNode.put("diagramBeginX", diagramInfo.getX());
                displayNode.put("diagramBeginY", diagramInfo.getY());
                displayNode.put("diagramWidth", diagramInfo.getWidth());
                displayNode.put("diagramHeight", diagramInfo.getHeight());
            }
            catch (Exception e) {
                LOGGER.error("Error creating model JSON", (Throwable)e);
            }
        }
        return displayNode;
    }

    @GetMapping(value={"/rest/admin/case-instances/{caseInstanceId}/model-json"}, produces={"application/json"})
    public JsonNode getCaseInstanceModelJSON(@PathVariable String caseInstanceId) {
        ObjectNode displayNode = this.objectMapper.createObjectNode();
        ServerConfig config = this.retrieveServerConfig(EndpointType.CMMN);
        JsonNode caseInstanceNode = this.caseInstanceService.getCaseInstance(config, caseInstanceId);
        if (caseInstanceNode == null) {
            return displayNode;
        }
        String caseDefinitionId = caseInstanceNode.get("caseDefinitionId").asText();
        CmmnModel pojoModel = this.clientService.getCaseDefinitionModel(config, caseDefinitionId);
        if (!pojoModel.getLocationMap().isEmpty()) {
            JsonNode planitemsInstanceNodes = this.caseInstanceService.getPlanItemInstancesForCaseInstance(config, caseInstanceId);
            HashSet<String> completedPlanItemInstances = new HashSet<String>();
            HashSet<String> activePlanItemInstances = new HashSet<String>();
            HashSet<String> availablePlanItemInstances = new HashSet<String>();
            if (planitemsInstanceNodes != null && planitemsInstanceNodes.has("data") && planitemsInstanceNodes.get("data").isArray()) {
                for (JsonNode planItemInstance : planitemsInstanceNodes.get("data")) {
                    if (planItemInstance.has("completedTime") && !planItemInstance.get("completedTime").isNull() || planItemInstance.has("terminatedTime") && !planItemInstance.get("terminatedTime").isNull() || planItemInstance.has("occurredTime") && !planItemInstance.get("occurredTime").isNull()) {
                        completedPlanItemInstances.add(planItemInstance.get("planItemDefinitionId").asText());
                        continue;
                    }
                    if ("active".equals(planItemInstance.get("state").asText())) {
                        activePlanItemInstances.add(planItemInstance.get("planItemDefinitionId").asText());
                        continue;
                    }
                    if (!"available".equals(planItemInstance.get("state").asText())) continue;
                    availablePlanItemInstances.add(planItemInstance.get("planItemDefinitionId").asText());
                }
            }
            GraphicInfo diagramInfo = new GraphicInfo();
            try {
                this.processCaseElements(pojoModel, displayNode, diagramInfo, completedPlanItemInstances, activePlanItemInstances, availablePlanItemInstances);
                displayNode.put("diagramBeginX", diagramInfo.getX());
                displayNode.put("diagramBeginY", diagramInfo.getY());
                displayNode.put("diagramWidth", diagramInfo.getWidth());
                displayNode.put("diagramHeight", diagramInfo.getHeight());
                ArrayNode completedActivities = displayNode.putArray("completedActivities");
                for (String string : completedPlanItemInstances) {
                    completedActivities.add(string);
                }
                ArrayNode currentActivities = displayNode.putArray("currentActivities");
                for (String current : activePlanItemInstances) {
                    currentActivities.add(current);
                }
                ArrayNode arrayNode = displayNode.putArray("availableActivities");
                for (String available : availablePlanItemInstances) {
                    arrayNode.add(available);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error creating model JSON", (Throwable)e);
            }
        }
        return displayNode;
    }

    protected void processCaseElements(CmmnModel pojoModel, ObjectNode displayNode, GraphicInfo diagramInfo, Set<String> completedElements, Set<String> activeElements, Set<String> availableElements) throws Exception {
        ObjectNode elementNode;
        if (pojoModel.getLocationMap().isEmpty()) {
            return;
        }
        ArrayNode elementArray = this.objectMapper.createArrayNode();
        ArrayNode flowArray = this.objectMapper.createArrayNode();
        diagramInfo.setX(9999.0);
        diagramInfo.setY(1000.0);
        for (Case caseObject : pojoModel.getCases()) {
            elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", caseObject.getPlanModel().getId());
            elementNode.put("name", caseObject.getPlanModel().getName());
            GraphicInfo graphicInfo = pojoModel.getGraphicInfo(caseObject.getPlanModel().getId());
            if (graphicInfo != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            elementNode.put("type", "PlanModel");
            elementArray.add((JsonNode)elementNode);
            this.processCriteria(caseObject.getPlanModel().getExitCriteria(), "ExitCriterion", pojoModel, elementArray);
            this.processElements(caseObject.getPlanModel().getPlanItems(), pojoModel, elementArray, flowArray, completedElements, activeElements, availableElements, diagramInfo);
        }
        for (Association association : pojoModel.getAssociations()) {
            elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", association.getId());
            elementNode.put("type", "Association");
            elementNode.put("sourceRef", association.getSourceRef());
            elementNode.put("targetRef", association.getTargetRef());
            List flowInfo = pojoModel.getFlowLocationGraphicInfo(association.getId());
            if (!CollectionUtils.isNotEmpty((Collection)flowInfo)) continue;
            ArrayNode waypointArray = this.objectMapper.createArrayNode();
            for (GraphicInfo graphicInfo : flowInfo) {
                ObjectNode pointNode = this.objectMapper.createObjectNode();
                this.fillGraphicInfo(pointNode, graphicInfo, false);
                waypointArray.add((JsonNode)pointNode);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            elementNode.set("waypoints", (JsonNode)waypointArray);
            flowArray.add((JsonNode)elementNode);
        }
        displayNode.set("elements", (JsonNode)elementArray);
        displayNode.set("flows", (JsonNode)flowArray);
        displayNode.put("diagramBeginX", diagramInfo.getX());
        displayNode.put("diagramBeginY", diagramInfo.getY());
        displayNode.put("diagramWidth", diagramInfo.getWidth());
        displayNode.put("diagramHeight", diagramInfo.getHeight());
    }

    protected void processElements(List<PlanItem> planItemList, CmmnModel model, ArrayNode elementArray, ArrayNode flowArray, Set<String> completedElements, Set<String> activeElements, Set<String> availableElements, GraphicInfo diagramInfo) {
        for (PlanItem planItem : planItemList) {
            ServiceTask serviceTask;
            ObjectNode elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", planItem.getId());
            elementNode.put("name", planItem.getName());
            GraphicInfo graphicInfo = model.getGraphicInfo(planItem.getId());
            if (graphicInfo != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
            String className = planItemDefinition.getClass().getSimpleName();
            elementNode.put("type", className);
            elementNode.put("planItemDefinitionId", planItemDefinition.getId());
            if (completedElements != null) {
                elementNode.put("completed", completedElements.contains(planItemDefinition.getId()));
            }
            if (activeElements != null) {
                elementNode.put("current", activeElements.contains(planItemDefinition.getId()));
            }
            if (availableElements != null) {
                elementNode.put("available", availableElements.contains(planItemDefinition.getId()));
            }
            if (planItemDefinition instanceof ServiceTask && "http".equals((serviceTask = (ServiceTask)planItemDefinition).getType())) {
                elementNode.put("taskType", "http");
            }
            elementArray.add((JsonNode)elementNode);
            this.processCriteria(planItem.getEntryCriteria(), "EntryCriterion", model, elementArray);
            this.processCriteria(planItem.getExitCriteria(), "ExitCriterion", model, elementArray);
            if (!(planItemDefinition instanceof Stage)) continue;
            Stage stage = (Stage)planItemDefinition;
            this.processElements(stage.getPlanItems(), model, elementArray, flowArray, completedElements, activeElements, availableElements, diagramInfo);
        }
    }

    protected void processCriteria(List<Criterion> criteria, String type, CmmnModel model, ArrayNode elementArray) {
        for (Criterion criterion : criteria) {
            ObjectNode criterionNode = this.objectMapper.createObjectNode();
            criterionNode.put("id", criterion.getId());
            criterionNode.put("name", criterion.getName());
            criterionNode.put("type", type);
            GraphicInfo criterionGraphicInfo = model.getGraphicInfo(criterion.getId());
            if (criterionGraphicInfo != null) {
                this.fillGraphicInfo(criterionNode, criterionGraphicInfo, true);
            }
            elementArray.add((JsonNode)criterionNode);
        }
    }

    protected void fillWaypoints(String id, CmmnModel model, ObjectNode elementNode, GraphicInfo diagramInfo) {
        List flowInfo = model.getFlowLocationGraphicInfo(id);
        ArrayNode waypointArray = this.objectMapper.createArrayNode();
        for (GraphicInfo graphicInfo : flowInfo) {
            ObjectNode pointNode = this.objectMapper.createObjectNode();
            this.fillGraphicInfo(pointNode, graphicInfo, false);
            waypointArray.add((JsonNode)pointNode);
            this.fillDiagramInfo(graphicInfo, diagramInfo);
        }
        elementNode.set("waypoints", (JsonNode)waypointArray);
    }

    protected void fillGraphicInfo(ObjectNode elementNode, GraphicInfo graphicInfo, boolean includeWidthAndHeight) {
        this.commonFillGraphicInfo(elementNode, graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight(), includeWidthAndHeight);
    }

    protected void commonFillGraphicInfo(ObjectNode elementNode, double x, double y, double width, double height, boolean includeWidthAndHeight) {
        elementNode.put("x", x);
        elementNode.put("y", y);
        if (includeWidthAndHeight) {
            elementNode.put("width", width);
            elementNode.put("height", height);
        }
    }

    protected void fillDiagramInfo(GraphicInfo graphicInfo, GraphicInfo diagramInfo) {
        double rightX = graphicInfo.getX() + graphicInfo.getWidth();
        double bottomY = graphicInfo.getY() + graphicInfo.getHeight();
        double middleX = graphicInfo.getX() + graphicInfo.getWidth() / 2.0;
        if (middleX < diagramInfo.getX()) {
            diagramInfo.setX(middleX);
        }
        if (graphicInfo.getY() < diagramInfo.getY()) {
            diagramInfo.setY(graphicInfo.getY());
        }
        if (rightX > diagramInfo.getWidth()) {
            diagramInfo.setWidth(rightX);
        }
        if (bottomY > diagramInfo.getHeight()) {
            diagramInfo.setHeight(bottomY);
        }
    }
}

