/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.CaseInstanceService;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CaseInstancesClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseInstancesClientResource.class);
    @Autowired
    protected CaseInstanceService clientService;
    protected ObjectMapper objectMapper = new ObjectMapper();

    @PostMapping(value={"/rest/admin/case-instances"}, consumes={"application/json"}, produces={"application/json"})
    public JsonNode listCaseInstances(@RequestBody ObjectNode bodyNode) {
        LOGGER.debug("REST request to get a list of case instances");
        JsonNode resultNode = null;
        try {
            ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
            resultNode = this.clientService.listCaseInstances(bodyNode, serverConfig);
        }
        catch (Exception e) {
            LOGGER.error("Error processing case instance list request", (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
        return resultNode;
    }
}

