/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.BatchService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BatchClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchClientResource.class);
    @Autowired
    protected BatchService clientService;

    @GetMapping(value={"/rest/admin/batches/{batchId}"}, produces={"application/json"})
    public JsonNode getBatch(@PathVariable String batchId, HttpServletRequest request) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            return this.clientService.getBatch(serverConfig, batchId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting batch {}", (Object)batchId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/batches/{batchId}/batch-parts"}, produces={"application/json"})
    public JsonNode getBatchParts(@PathVariable String batchId, HttpServletRequest request) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
            return this.clientService.listBatchParts(serverConfig, batchId, parameterMap);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting batch parts for batch {}", (Object)batchId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @DeleteMapping(value={"/rest/admin/batches/{batchId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteJob(@PathVariable String batchId, HttpServletRequest request) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            this.clientService.deleteBatch(serverConfig, batchId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error deleting batch {}", (Object)batchId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/batches/{batchId}/batch-document"}, produces={"text/plain"})
    public String getBatchDocument(@PathVariable String batchId, HttpServletRequest request) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            return this.clientService.getBatchDocument(serverConfig, batchId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting batch document {}", (Object)batchId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

