/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.ldap;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.flowable.ldap.LDAPConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="flowable.idm.ldap")
public class FlowableLdapProperties {
    private boolean enabled = false;
    private String server;
    private int port = -1;
    private String user;
    private String password;
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String securityAuthentication = "simple";
    private Map<String, String> customConnectionParameters = new HashMap<String, String>();
    private String baseDn;
    private String userBaseDn;
    private String groupBaseDn;
    private int searchTimeLimit = 0;
    private boolean connectionPooling = true;
    @NestedConfigurationProperty
    private final Query query = new Query();
    @NestedConfigurationProperty
    private final Attribute attribute = new Attribute();
    @NestedConfigurationProperty
    private final Cache cache = new Cache();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public String getSecurityAuthentication() {
        return this.securityAuthentication;
    }

    public void setSecurityAuthentication(String securityAuthentication) {
        this.securityAuthentication = securityAuthentication;
    }

    public Map<String, String> getCustomConnectionParameters() {
        return this.customConnectionParameters;
    }

    public void setCustomConnectionParameters(Map<String, String> customConnectionParameters) {
        this.customConnectionParameters = customConnectionParameters;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public String getUserBaseDn() {
        return this.userBaseDn;
    }

    public void setUserBaseDn(String userBaseDn) {
        this.userBaseDn = userBaseDn;
    }

    public String getGroupBaseDn() {
        return this.groupBaseDn;
    }

    public void setGroupBaseDn(String groupBaseDn) {
        this.groupBaseDn = groupBaseDn;
    }

    public int getSearchTimeLimit() {
        return this.searchTimeLimit;
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchTimeLimit = searchTimeLimit;
    }

    public boolean isConnectionPooling() {
        return this.connectionPooling;
    }

    public void setConnectionPooling(boolean connectionPooling) {
        this.connectionPooling = connectionPooling;
    }

    public Query getQuery() {
        return this.query;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void customize(LDAPConfiguration configuration) {
        configuration.setServer(this.getServer());
        configuration.setPort(this.getPort());
        configuration.setUser(this.getUser());
        configuration.setPassword(this.getPassword());
        configuration.setInitialContextFactory(this.getInitialContextFactory());
        configuration.setSecurityAuthentication(this.getSecurityAuthentication());
        configuration.setCustomConnectionParameters(this.getCustomConnectionParameters());
        configuration.setBaseDn(this.getBaseDn());
        configuration.setUserBaseDn(this.getUserBaseDn());
        configuration.setGroupBaseDn(this.getGroupBaseDn());
        configuration.setSearchTimeLimit(this.getSearchTimeLimit());
        configuration.setConnectionPooling(this.isConnectionPooling());
        this.query.customize(configuration);
        this.attribute.customize(configuration);
        this.cache.customize(configuration);
    }

    public static class Query {
        private String userById;
        private String userByFullNameLike;
        private String allUsers;
        private String groupsForUser;
        private String allGroups;
        private String groupById;

        public String getUserById() {
            return this.userById;
        }

        public void setUserById(String userById) {
            this.userById = userById;
        }

        public String getUserByFullNameLike() {
            return this.userByFullNameLike;
        }

        public void setUserByFullNameLike(String userByFullNameLike) {
            this.userByFullNameLike = userByFullNameLike;
        }

        public String getAllUsers() {
            return this.allUsers;
        }

        public void setAllUsers(String allUsers) {
            this.allUsers = allUsers;
        }

        public String getGroupsForUser() {
            return this.groupsForUser;
        }

        public void setGroupsForUser(String groupsForUser) {
            this.groupsForUser = groupsForUser;
        }

        public String getAllGroups() {
            return this.allGroups;
        }

        public void setAllGroups(String allGroups) {
            this.allGroups = allGroups;
        }

        public String getGroupById() {
            return this.groupById;
        }

        public void setGroupById(String groupById) {
            this.groupById = groupById;
        }

        public void customize(LDAPConfiguration configuration) {
            configuration.setQueryUserByUserId(this.getUserById());
            configuration.setQueryUserByFullNameLike(this.getUserByFullNameLike());
            configuration.setQueryAllUsers(this.getAllUsers());
            configuration.setQueryGroupsForUser(this.getGroupsForUser());
            configuration.setQueryAllGroups(this.getAllGroups());
            configuration.setQueryGroupByGroupId(this.getGroupById());
        }
    }

    public static class Attribute {
        private String userId;
        private String firstName;
        private String lastName;
        private String email;
        private String groupId;
        private String groupName;
        private String groupType;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getGroupType() {
            return this.groupType;
        }

        public void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        public void customize(LDAPConfiguration configuration) {
            configuration.setUserIdAttribute(this.getUserId());
            configuration.setUserFirstNameAttribute(this.getFirstName());
            configuration.setUserLastNameAttribute(this.getLastName());
            configuration.setUserEmailAttribute(this.getEmail());
            configuration.setGroupIdAttribute(this.getGroupId());
            configuration.setGroupNameAttribute(this.getGroupName());
            configuration.setGroupTypeAttribute(this.getGroupType());
        }
    }

    public static class Cache {
        private int groupSize = -1;
        private long groupExpiration = Duration.of(1L, ChronoUnit.HOURS).toMillis();

        public int getGroupSize() {
            return this.groupSize;
        }

        public void setGroupSize(int groupSize) {
            this.groupSize = groupSize;
        }

        public long getGroupExpiration() {
            return this.groupExpiration;
        }

        public void setGroupExpiration(int groupExpiration) {
            this.groupExpiration = groupExpiration;
        }

        public void customize(LDAPConfiguration configuration) {
            configuration.setGroupCacheSize(this.getGroupSize());
            configuration.setGroupCacheExpirationTime(this.getGroupExpiration());
        }
    }
}

