/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import org.flowable.app.engine.AppEngine;
import org.flowable.app.rest.AppRestUrls;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.rest.service.api.CmmnRestUrls;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.common.rest.resolver.DefaultContentTypeResolver;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.rest.service.api.DmnRestUrls;
import org.flowable.engine.ProcessEngine;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.rest.service.api.EventRestUrls;
import org.flowable.external.job.rest.service.api.ExternalJobRestUrls;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.rest.service.api.IdmRestResponseFactory;
import org.flowable.rest.service.api.RestUrls;
import org.flowable.spring.boot.FlowableSecurityAutoConfiguration;
import org.flowable.spring.boot.FlowableServlet;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineRestConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.FlowableAppProperties;
import org.flowable.spring.boot.cmmn.CmmnEngineRestConfiguration;
import org.flowable.spring.boot.cmmn.CmmnEngineServicesAutoConfiguration;
import org.flowable.spring.boot.cmmn.FlowableCmmnProperties;
import org.flowable.spring.boot.dmn.DmnEngineRestConfiguration;
import org.flowable.spring.boot.dmn.DmnEngineServicesAutoConfiguration;
import org.flowable.spring.boot.dmn.FlowableDmnProperties;
import org.flowable.spring.boot.eventregistry.EventRegistryRestConfiguration;
import org.flowable.spring.boot.eventregistry.EventRegistryServicesAutoConfiguration;
import org.flowable.spring.boot.eventregistry.FlowableEventRegistryProperties;
import org.flowable.spring.boot.idm.FlowableIdmProperties;
import org.flowable.spring.boot.idm.IdmEngineRestConfiguration;
import org.flowable.spring.boot.idm.IdmEngineServicesAutoConfiguration;
import org.flowable.spring.boot.job.ExternalJobRestConfiguration;
import org.flowable.spring.boot.process.FlowableProcessProperties;
import org.flowable.spring.boot.process.ProcessEngineRestConfiguration;
import org.flowable.spring.boot.rest.BaseRestApiConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.MultipartAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@ConditionalOnClass(value={ContentTypeResolver.class})
@ConditionalOnWebApplication
@AutoConfiguration(after={MultipartAutoConfiguration.class, FlowableSecurityAutoConfiguration.class, AppEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class, CmmnEngineServicesAutoConfiguration.class, DmnEngineServicesAutoConfiguration.class, EventRegistryServicesAutoConfiguration.class, IdmEngineServicesAutoConfiguration.class})
public class RestApiAutoConfiguration {
    @Bean
    public ContentTypeResolver contentTypeResolver() {
        DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
        return resolver;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={IdmRestResponseFactory.class})
    @ConditionalOnBean(value={IdmEngine.class})
    public static class IdmEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean idmServlet(FlowableIdmProperties properties) {
            return this.registerServlet(properties.getServlet(), IdmEngineRestConfiguration.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EventRestUrls.class})
    @ConditionalOnBean(value={EventRegistryEngine.class})
    public static class EventRegistryRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean eventRegistryServlet(FlowableEventRegistryProperties properties) {
            return this.registerServlet(properties.getServlet(), EventRegistryRestConfiguration.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={DmnRestUrls.class})
    @ConditionalOnBean(value={DmnEngine.class})
    public static class DmnEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean dmnServlet(FlowableDmnProperties properties) {
            return this.registerServlet(properties.getServlet(), DmnEngineRestConfiguration.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CmmnRestUrls.class})
    @ConditionalOnBean(value={CmmnEngine.class})
    public static class CmmnEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean cmmnServlet(FlowableCmmnProperties properties) {
            return this.registerServlet(properties.getServlet(), CmmnEngineRestConfiguration.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={AppRestUrls.class})
    @ConditionalOnBean(value={AppEngine.class})
    public static class AppEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean appServlet(FlowableAppProperties properties) {
            return this.registerServlet(properties.getServlet(), AppEngineRestConfiguration.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ExternalJobRestUrls.class})
    @Conditional(value={ExternalJobRestCondition.class})
    @EnableConfigurationProperties(value={FlowableProcessProperties.class})
    public static class ExternalJobRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean externalJobRestService(FlowableProcessProperties properties) {
            FlowableServlet servlet = new FlowableServlet("/external-job-api", "Flowable External Job Rest API");
            FlowableServlet processServlet = properties.getServlet();
            servlet.setLoadOnStartup(processServlet.getLoadOnStartup());
            return this.registerServlet(servlet, ExternalJobRestConfiguration.class);
        }

        static final class ExternalJobRestCondition
        extends AnyNestedCondition {
            ExternalJobRestCondition() {
                super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
            }

            @ConditionalOnBean(value={CmmnEngine.class})
            private static final class CmmnEngineBeanCondition {
                private CmmnEngineBeanCondition() {
                }
            }

            @ConditionalOnBean(value={ProcessEngine.class})
            private static final class ProcessEngineBeanCondition {
                private ProcessEngineBeanCondition() {
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestUrls.class})
    @ConditionalOnBean(value={ProcessEngine.class})
    @EnableConfigurationProperties(value={FlowableProcessProperties.class})
    public static class ProcessEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean processService(FlowableProcessProperties properties) {
            return this.registerServlet(properties.getServlet(), ProcessEngineRestConfiguration.class);
        }
    }
}

