/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.security;

import org.flowable.idm.api.IdmIdentityService;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

public class FlowableAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    protected final IdmIdentityService idmIdentityService;
    protected final UserDetailsService userDetailsService;

    public FlowableAuthenticationProvider(IdmIdentityService idmIdentityService, UserDetailsService userDetailsService) {
        this.idmIdentityService = idmIdentityService;
        this.userDetailsService = userDetailsService;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        String password;
        String name = userDetails.getUsername();
        boolean authenticated = this.idmIdentityService.checkPassword(name, password = authentication.getCredentials().toString());
        if (!authenticated) {
            throw new BadCredentialsException("Authentication failed for this username and password");
        }
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        return this.userDetailsService.loadUserByUsername(username);
    }
}

