/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.integration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.spring.integration.IntegrationActivityBehavior;
import org.flowable.spring.integration.ProcessVariableHeaderMapper;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class FlowableInboundGateway
extends MessagingGatewaySupport {
    private String executionId = "executionId";
    private String processInstanceId = "processInstanceId";
    private String processDefinitionId = "processDefinitionId";
    private final ProcessVariableHeaderMapper headerMapper;
    private ProcessEngine processEngine;
    private Set<String> sync = new ConcurrentSkipListSet<String>();

    public FlowableInboundGateway(ProcessEngine processEngine, String ... pvsOrHeadersToPreserve) {
        Collections.addAll(this.sync, pvsOrHeadersToPreserve);
        this.processEngine = processEngine;
        this.headerMapper = new ProcessVariableHeaderMapper(this.sync);
        this.initializeDefaultPreservedHeaders();
    }

    protected void initializeDefaultPreservedHeaders() {
        this.sync.add(this.executionId);
        this.sync.add(this.processDefinitionId);
        this.sync.add(this.processInstanceId);
    }

    public void execute(IntegrationActivityBehavior receiveTaskActivityBehavior, DelegateExecution execution) {
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        stringObjectMap.put(this.executionId, execution.getId());
        stringObjectMap.put(this.processInstanceId, execution.getProcessInstanceId());
        stringObjectMap.put(this.processDefinitionId, execution.getProcessDefinitionId());
        stringObjectMap.putAll(this.headerMapper.toHeaders(execution.getVariables()));
        MessageBuilder mb = MessageBuilder.withPayload((Object)execution).copyHeaders(stringObjectMap);
        Message reply = this.sendAndReceiveMessage(mb.build());
        if (null != reply) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            this.headerMapper.fromHeaders(reply.getHeaders(), vars);
            for (String k : vars.keySet()) {
                this.processEngine.getRuntimeService().setVariable(execution.getId(), k, vars.get(k));
            }
            receiveTaskActivityBehavior.leave(execution);
        }
    }

    public void signal(IntegrationActivityBehavior receiveTaskActivityBehavior, DelegateExecution execution, String signalName, Object data) {
        receiveTaskActivityBehavior.leave(execution);
    }
}

