/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import org.flowable.engine.IdentityService;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnIdmEngine;
import org.flowable.spring.boot.idm.IdmEngineServicesAutoConfiguration;
import org.flowable.spring.security.FlowableAuthenticationProvider;
import org.flowable.spring.security.FlowableUserDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsService;

@Configuration
@ConditionalOnIdmEngine
@ConditionalOnClass(value={AuthenticationManager.class, GlobalAuthenticationConfigurerAdapter.class})
@AutoConfigureBefore(value={org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration.class})
@AutoConfigureAfter(value={IdmEngineServicesAutoConfiguration.class, ProcessEngineAutoConfiguration.class})
public class SecurityAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={UserDetailsService.class})
    public FlowableUserDetailsService flowableUserDetailsService(IdmIdentityService identityService) {
        return new FlowableUserDetailsService(identityService);
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthenticationProvider.class})
    public FlowableAuthenticationProvider flowableAuthenticationProvider(IdmIdentityService idmIdentityService, UserDetailsService userDetailsService) {
        return new FlowableAuthenticationProvider(idmIdentityService, userDetailsService);
    }

    @ConditionalOnBean(type={"org.flowable.idm.api.IdmIdentityService"})
    @Configuration
    protected static class IdmIdentitySecurityConfiguration
    implements ApplicationListener<AuthenticationSuccessEvent> {
        protected final IdmIdentityService identityService;

        public IdmIdentitySecurityConfiguration(IdmIdentityService identityService) {
            this.identityService = identityService;
        }

        public void onApplicationEvent(AuthenticationSuccessEvent event) {
            this.identityService.setAuthenticatedUserId(event.getAuthentication().getName());
        }
    }

    @ConditionalOnBean(type={"org.flowable.engine.IdentityService"})
    @ConditionalOnMissingBean(type={"org.flowable.idm.api.IdmIdentityService"})
    @Configuration
    protected static class IdentitySecurityConfiguration
    implements ApplicationListener<AuthenticationSuccessEvent> {
        protected final IdentityService identityService;

        public IdentitySecurityConfiguration(IdentityService identityService) {
            this.identityService = identityService;
        }

        public void onApplicationEvent(AuthenticationSuccessEvent event) {
            this.identityService.setAuthenticatedUserId(event.getAuthentication().getName());
        }
    }

    @Configuration
    public static class UserDetailsServiceConfiguration
    extends GlobalAuthenticationConfigurerAdapter {
        protected final ObjectProvider<AuthenticationProvider> authenticationProviderProvider;
        protected final ObjectProvider<UserDetailsService> userDetailsServiceProvider;

        public UserDetailsServiceConfiguration(ObjectProvider<AuthenticationProvider> authenticationProviderProvider, ObjectProvider<UserDetailsService> userDetailsServiceProvider) {
            this.authenticationProviderProvider = authenticationProviderProvider;
            this.userDetailsServiceProvider = userDetailsServiceProvider;
        }

        public void init(AuthenticationManagerBuilder auth) throws Exception {
            if (!auth.isConfigured()) {
                AuthenticationProvider authenticationProvider = (AuthenticationProvider)this.authenticationProviderProvider.getIfUnique();
                if (authenticationProvider != null) {
                    auth.authenticationProvider(authenticationProvider);
                } else {
                    LOGGER.warn("There is no authentication provider configured. However, there is no single one in the context. Please configure the global authentication provider by yourself.");
                }
            }
        }
    }
}

