/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ldap;

import java.text.MessageFormat;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Rdn;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.ldap.LDAPCallBack;
import org.flowable.ldap.LDAPConfiguration;
import org.flowable.ldap.LDAPTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPQueryBuilder {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LDAPQueryBuilder.class);

    public String buildQueryByUserId(LDAPConfiguration ldapConfigurator, String userId) {
        String searchExpression = null;
        searchExpression = ldapConfigurator.getQueryUserByUserId() != null ? MessageFormat.format(ldapConfigurator.getQueryUserByUserId(), userId) : userId;
        return searchExpression;
    }

    public String buildQueryGroupsForUser(final LDAPConfiguration ldapConfigurator, final String userId) {
        String searchExpression = null;
        if (ldapConfigurator.getQueryGroupsForUser() != null) {
            LDAPTemplate ldapTemplate = new LDAPTemplate(ldapConfigurator);
            String userDn = ldapTemplate.execute(new LDAPCallBack<String>(){

                @Override
                public String executeInContext(InitialDirContext initialDirContext) {
                    String userDnSearch = LDAPQueryBuilder.this.buildQueryByUserId(ldapConfigurator, userId);
                    try {
                        String baseDn = ldapConfigurator.getUserBaseDn() != null ? ldapConfigurator.getUserBaseDn() : ldapConfigurator.getBaseDn();
                        NamingEnumeration<SearchResult> namingEnum = initialDirContext.search(baseDn, userDnSearch, LDAPQueryBuilder.this.createSearchControls(ldapConfigurator));
                        if (namingEnum.hasMore()) {
                            SearchResult result = namingEnum.next();
                            return result.getNameInNamespace();
                        }
                        namingEnum.close();
                    }
                    catch (NamingException e) {
                        LOGGER.debug("Could not find user dn : {}", (Object)e.getMessage(), (Object)e);
                    }
                    return null;
                }
            });
            searchExpression = MessageFormat.format(ldapConfigurator.getQueryGroupsForUser(), Rdn.escapeValue(userDn));
        } else {
            searchExpression = userId;
        }
        return searchExpression;
    }

    public String buildQueryByFullNameLike(LDAPConfiguration ldapConfigurator, String searchText) {
        String searchExpression = null;
        if (ldapConfigurator.getQueryUserByFullNameLike() == null) {
            throw new FlowableIllegalArgumentException("No 'queryUserByFullNameLike' configured");
        }
        searchExpression = MessageFormat.format(ldapConfigurator.getQueryUserByFullNameLike(), ldapConfigurator.getUserFirstNameAttribute(), searchText, ldapConfigurator.getUserLastNameAttribute(), searchText);
        return searchExpression;
    }

    public String buildQueryGroupsById(LDAPConfiguration ldapConfigurator, String groupId) {
        String searchExpression = ldapConfigurator.getQueryGroupByGroupId() != null ? MessageFormat.format(ldapConfigurator.getQueryGroupByGroupId(), groupId) : groupId;
        return searchExpression;
    }

    protected SearchControls createSearchControls(LDAPConfiguration ldapConfigurator) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(ldapConfigurator.getSearchTimeLimit());
        return searchControls;
    }
}

