/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.rest.service.api.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.exception.FlowableConflictException;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.api.UserQueryProperty;
import org.flowable.idm.rest.service.api.IdmRestApiInterceptor;
import org.flowable.idm.rest.service.api.IdmRestResponseFactory;
import org.flowable.idm.rest.service.api.user.UserRequest;
import org.flowable.idm.rest.service.api.user.UserResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Users"}, description="Manage Users", authorizations={@Authorization(value="basicAuth")})
public class UserCollectionResource {
    protected static HashMap<String, QueryProperty> properties = new HashMap();
    @Autowired
    protected IdmRestResponseFactory idmRestResponseFactory;
    @Autowired
    protected IdmIdentityService identityService;
    @Autowired(required=false)
    protected IdmRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="List users", nickname="listUsers", tags={"Users"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", dataType="string", value="Only return group with the given id", paramType="query"), @ApiImplicitParam(name="firstName", dataType="string", value="Only return users with the given firstname", paramType="query"), @ApiImplicitParam(name="lastName", dataType="string", value="Only return users with the given lastname", paramType="query"), @ApiImplicitParam(name="displayName", dataType="string", value="Only return users with the given displayName", paramType="query"), @ApiImplicitParam(name="email", dataType="string", value="Only return users with the given email", paramType="query"), @ApiImplicitParam(name="firstNameLike", dataType="string", value="Only return users with a firstname like the given value.", paramType="query"), @ApiImplicitParam(name="lastNameLike", dataType="string", value="Only return users with a lastname like the given value. ", paramType="query"), @ApiImplicitParam(name="displayNameLike", dataType="string", value="Only return users with a displayName like the given value. ", paramType="query"), @ApiImplicitParam(name="emailLike", dataType="string", value="Only return users with an email like the given value.", paramType="query"), @ApiImplicitParam(name="memberOfGroup", dataType="string", value="Only return users which are a member of the given group.", paramType="query"), @ApiImplicitParam(name="sort", dataType="string", value="Property to sort on, to be used together with the order.", allowableValues="id,firstName,lastname,email,displayName", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the group exists and is returned.")})
    @GetMapping(value={"/users"}, produces={"application/json"})
    public DataResponse<UserResponse> getUsers(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams) {
        UserQuery query = this.identityService.createUserQuery();
        if (allRequestParams.containsKey("id")) {
            query.userId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("firstName")) {
            query.userFirstName(allRequestParams.get("firstName"));
        }
        if (allRequestParams.containsKey("lastName")) {
            query.userLastName(allRequestParams.get("lastName"));
        }
        if (allRequestParams.containsKey("displayName")) {
            query.userDisplayName(allRequestParams.get("displayName"));
        }
        if (allRequestParams.containsKey("email")) {
            query.userEmail(allRequestParams.get("email"));
        }
        if (allRequestParams.containsKey("firstNameLike")) {
            query.userFirstNameLike(allRequestParams.get("firstNameLike"));
        }
        if (allRequestParams.containsKey("lastNameLike")) {
            query.userLastNameLike(allRequestParams.get("lastNameLike"));
        }
        if (allRequestParams.containsKey("displayNameLike")) {
            query.userDisplayNameLike(allRequestParams.get("displayNameLike"));
        }
        if (allRequestParams.containsKey("emailLike")) {
            query.userEmailLike(allRequestParams.get("emailLike"));
        }
        if (allRequestParams.containsKey("memberOfGroup")) {
            query.memberOfGroup(allRequestParams.get("memberOfGroup"));
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessUserInfoWithQuery(query);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)query, (String)"id", properties, this.idmRestResponseFactory::createUserResponseList);
    }

    @ApiOperation(value="Create a user", tags={"Users"}, code=201)
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the user was created."), @ApiResponse(code=400, message="Indicates the id of the user was missing.")})
    @PostMapping(value={"/users"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public UserResponse createUser(@RequestBody UserRequest userRequest) {
        if (userRequest.getId() == null) {
            throw new FlowableIllegalArgumentException("Id cannot be null.");
        }
        if (((UserQuery)this.identityService.createUserQuery().userId(userRequest.getId())).count() > 0L) {
            throw new FlowableConflictException("A user with id '" + userRequest.getId() + "' already exists.");
        }
        User created = this.identityService.newUser(userRequest.getId());
        created.setEmail(userRequest.getEmail());
        created.setFirstName(userRequest.getFirstName());
        created.setLastName(userRequest.getLastName());
        created.setDisplayName(userRequest.getDisplayName());
        created.setPassword(userRequest.getPassword());
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.createNewUser(created);
        }
        this.identityService.saveUser(created);
        return this.idmRestResponseFactory.createUserResponse(created, false);
    }

    static {
        properties.put("id", (QueryProperty)UserQueryProperty.USER_ID);
        properties.put("firstName", (QueryProperty)UserQueryProperty.FIRST_NAME);
        properties.put("lastName", (QueryProperty)UserQueryProperty.LAST_NAME);
        properties.put("displayName", (QueryProperty)UserQueryProperty.DISPLAY_NAME);
        properties.put("email", (QueryProperty)UserQueryProperty.EMAIL);
    }
}

