/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl;

import java.sql.Connection;
import java.util.Map;
import org.flowable.common.engine.api.management.TableMetaData;
import org.flowable.common.engine.api.management.TablePageQuery;
import org.flowable.common.engine.impl.cmd.CustomSqlExecution;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.idm.api.IdmManagementService;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.TablePageQueryImpl;
import org.flowable.idm.engine.impl.cmd.ExecuteCustomSqlCmd;
import org.flowable.idm.engine.impl.cmd.GetPropertiesCmd;
import org.flowable.idm.engine.impl.cmd.GetTableCountCmd;
import org.flowable.idm.engine.impl.cmd.GetTableMetaDataCmd;
import org.flowable.idm.engine.impl.cmd.GetTableNameCmd;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class IdmManagementServiceImpl
extends CommonEngineServiceImpl<IdmEngineConfiguration>
implements IdmManagementService {
    public Map<String, Long> getTableCount() {
        return (Map)this.commandExecutor.execute((Command)new GetTableCountCmd());
    }

    public String getTableName(Class<?> entityClass) {
        return (String)this.commandExecutor.execute((Command)new GetTableNameCmd(entityClass));
    }

    public TableMetaData getTableMetaData(String tableName) {
        return (TableMetaData)this.commandExecutor.execute((Command)new GetTableMetaDataCmd(tableName));
    }

    public TablePageQuery createTablePageQuery() {
        return new TablePageQueryImpl(this.commandExecutor);
    }

    public Map<String, String> getProperties() {
        return (Map)this.commandExecutor.execute((Command)new GetPropertiesCmd());
    }

    public String databaseSchemaUpgrade(Connection connection, String catalog, String schema) {
        CommandConfig config = this.commandExecutor.getDefaultConfig().transactionNotSupported();
        return (String)this.commandExecutor.execute(config, (Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                return CommandContextUtil.getIdmEngineConfiguration().getDbSchemaManager().dbSchemaUpdate();
            }
        });
    }

    public <MapperType, ResultType> ResultType executeCustomSql(CustomSqlExecution<MapperType, ResultType> customSqlExecution) {
        Class mapperClass = customSqlExecution.getMapperClass();
        return (ResultType)this.commandExecutor.execute(new ExecuteCustomSqlCmd<MapperType, ResultType>(mapperClass, customSqlExecution));
    }
}

