/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl;

import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.IdmManagementService;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.IdmEngines;
import org.flowable.idm.engine.impl.SchemaOperationsIdmEngineBuild;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdmEngineImpl
implements IdmEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdmEngineImpl.class);
    protected String name;
    protected IdmIdentityService identityService;
    protected IdmManagementService managementService;
    protected IdmEngineConfiguration engineConfiguration;
    protected CommandExecutor commandExecutor;

    public IdmEngineImpl(IdmEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
        this.name = engineConfiguration.getEngineName();
        this.identityService = engineConfiguration.getIdmIdentityService();
        this.managementService = engineConfiguration.getIdmManagementService();
        this.commandExecutor = engineConfiguration.getCommandExecutor();
        if (engineConfiguration.isUsingRelationalDatabase() && engineConfiguration.getDatabaseSchemaUpdate() != null) {
            this.commandExecutor.execute(engineConfiguration.getSchemaCommandConfig(), (Command)new SchemaOperationsIdmEngineBuild());
        }
        if (this.name == null) {
            LOGGER.info("default flowable IdmEngine created");
        } else {
            LOGGER.info("IdmEngine {} created", (Object)this.name);
        }
        IdmEngines.registerIdmEngine(this);
    }

    @Override
    public void close() {
        IdmEngines.unregister(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IdmIdentityService getIdmIdentityService() {
        return this.identityService;
    }

    @Override
    public IdmManagementService getIdmManagementService() {
        return this.managementService;
    }

    @Override
    public IdmEngineConfiguration getIdmEngineConfiguration() {
        return this.engineConfiguration;
    }
}

