/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.rest;

import java.util.ArrayList;
import java.util.List;
import org.flowable.form.api.FormDefinition;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormInstance;
import org.flowable.form.api.FormInstanceInfo;
import org.flowable.form.rest.FormRestUrlBuilder;
import org.flowable.form.rest.FormRestUrls;
import org.flowable.form.rest.service.api.form.FormInstanceModelResponse;
import org.flowable.form.rest.service.api.form.FormInstanceResponse;
import org.flowable.form.rest.service.api.form.FormModelResponse;
import org.flowable.form.rest.service.api.repository.FormDefinitionResponse;
import org.flowable.form.rest.service.api.repository.FormDeploymentResponse;

public class FormRestResponseFactory {
    public FormModelResponse createFormModelResponse(FormInfo formModel) {
        return this.createFormModelResponse(formModel, this.createUrlBuilder());
    }

    public FormModelResponse createFormModelResponse(FormInfo formModel, FormRestUrlBuilder urlBuilder) {
        FormModelResponse response = new FormModelResponse(formModel);
        response.setUrl(urlBuilder.buildUrl(FormRestUrls.URL_FORM_MODEL, new Object[0]));
        return response;
    }

    public List<FormInstanceResponse> createFormInstanceResponse(List<FormInstance> formInstances) {
        FormRestUrlBuilder urlBuilder = new FormRestUrlBuilder();
        ArrayList<FormInstanceResponse> responseList = new ArrayList<FormInstanceResponse>(formInstances.size());
        for (FormInstance formInstance : formInstances) {
            responseList.add(this.createFormInstanceResponse(formInstance, urlBuilder));
        }
        return responseList;
    }

    public FormInstanceResponse createFormInstanceResponse(FormInstance formInstance) {
        return this.createFormInstanceResponse(formInstance, this.createUrlBuilder());
    }

    public FormInstanceResponse createFormInstanceResponse(FormInstance formInstance, FormRestUrlBuilder urlBuilder) {
        FormInstanceResponse response = new FormInstanceResponse(formInstance);
        response.setUrl(urlBuilder.buildUrl(FormRestUrls.URL_FORM_INSTANCE_QUERY, new Object[0]));
        return response;
    }

    public List<FormInstanceModelResponse> createFormInstanceModelResponse(List<FormInstanceInfo> formInstanceModels) {
        FormRestUrlBuilder urlBuilder = new FormRestUrlBuilder();
        ArrayList<FormInstanceModelResponse> responseList = new ArrayList<FormInstanceModelResponse>(formInstanceModels.size());
        for (FormInstanceInfo formInstanceModel : formInstanceModels) {
            responseList.add(this.createFormInstanceModelResponse(formInstanceModel, urlBuilder));
        }
        return responseList;
    }

    public FormInstanceModelResponse createFormInstanceModelResponse(FormInstanceInfo formInstanceModel) {
        return this.createFormInstanceModelResponse(formInstanceModel, this.createUrlBuilder());
    }

    public FormInstanceModelResponse createFormInstanceModelResponse(FormInstanceInfo formInstanceModel, FormRestUrlBuilder urlBuilder) {
        FormInstanceModelResponse response = new FormInstanceModelResponse(formInstanceModel);
        response.setUrl(urlBuilder.buildUrl(FormRestUrls.URL_FORM_INSTANCE_MODEL, new Object[0]));
        return response;
    }

    public FormDefinitionResponse createFormDefinitionResponse(FormDefinition formDefinition) {
        return this.createFormDefinitionResponse(formDefinition, this.createUrlBuilder());
    }

    public FormDefinitionResponse createFormDefinitionResponse(FormDefinition formDefinition, FormRestUrlBuilder urlBuilder) {
        FormDefinitionResponse response = new FormDefinitionResponse(formDefinition);
        response.setUrl(urlBuilder.buildUrl(FormRestUrls.URL_FORM_DEFINITION, formDefinition.getId()));
        return response;
    }

    public List<FormDefinitionResponse> createFormResponseList(List<FormDefinition> formDefinitions) {
        FormRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<FormDefinitionResponse> responseList = new ArrayList<FormDefinitionResponse>(formDefinitions.size());
        for (FormDefinition formDefinition : formDefinitions) {
            responseList.add(this.createFormDefinitionResponse(formDefinition, urlBuilder));
        }
        return responseList;
    }

    public List<FormDeploymentResponse> createFormDeploymentResponseList(List<FormDeployment> deployments) {
        FormRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<FormDeploymentResponse> responseList = new ArrayList<FormDeploymentResponse>(deployments.size());
        for (FormDeployment instance : deployments) {
            responseList.add(this.createFormDeploymentResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public FormDeploymentResponse createFormDeploymentResponse(FormDeployment deployment) {
        return this.createFormDeploymentResponse(deployment, this.createUrlBuilder());
    }

    public FormDeploymentResponse createFormDeploymentResponse(FormDeployment deployment, FormRestUrlBuilder urlBuilder) {
        return new FormDeploymentResponse(deployment, urlBuilder.buildUrl(FormRestUrls.URL_DEPLOYMENT, deployment.getId()));
    }

    protected FormRestUrlBuilder createUrlBuilder() {
        return FormRestUrlBuilder.fromCurrentRequest();
    }
}

