/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.ChannelDefinitionQuery;
import org.flowable.eventregistry.impl.ChannelDefinitionQueryProperty;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class ChannelDefinitionQueryImpl
extends AbstractQuery<ChannelDefinitionQuery, ChannelDefinition>
implements ChannelDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected Set<String> ids;
    protected String category;
    protected String categoryLike;
    protected String categoryNotEquals;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected Set<String> deploymentIds;
    protected String parentDeploymentId;
    protected String key;
    protected String keyLike;
    protected Integer version;
    protected Integer versionGt;
    protected Integer versionGte;
    protected Integer versionLt;
    protected Integer versionLte;
    protected boolean latest;
    protected Date createTime;
    protected Date createTimeAfter;
    protected Date createTimeBefore;
    protected String resourceName;
    protected String resourceNameLike;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;

    public ChannelDefinitionQueryImpl() {
    }

    public ChannelDefinitionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public ChannelDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public ChannelDefinitionQueryImpl channelDefinitionId(String channelDefinitionId) {
        this.id = channelDefinitionId;
        return this;
    }

    public ChannelDefinitionQueryImpl channelDefinitionIds(Set<String> channelDefinitionIds) {
        this.ids = channelDefinitionIds;
        return this;
    }

    public ChannelDefinitionQueryImpl channelCategory(String category) {
        if (category == null) {
            throw new FlowableIllegalArgumentException("category is null");
        }
        this.category = category;
        return this;
    }

    public ChannelDefinitionQueryImpl channelCategoryLike(String categoryLike) {
        if (categoryLike == null) {
            throw new FlowableIllegalArgumentException("categoryLike is null");
        }
        this.categoryLike = categoryLike;
        return this;
    }

    public ChannelDefinitionQueryImpl channelCategoryNotEquals(String categoryNotEquals) {
        if (categoryNotEquals == null) {
            throw new FlowableIllegalArgumentException("categoryNotEquals is null");
        }
        this.categoryNotEquals = categoryNotEquals;
        return this;
    }

    public ChannelDefinitionQueryImpl channelDefinitionName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    public ChannelDefinitionQueryImpl channelDefinitionNameLike(String nameLike) {
        if (nameLike == null) {
            throw new FlowableIllegalArgumentException("nameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    public ChannelDefinitionQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    public ChannelDefinitionQueryImpl deploymentIds(Set<String> deploymentIds) {
        if (deploymentIds == null) {
            throw new FlowableIllegalArgumentException("ids are null");
        }
        this.deploymentIds = deploymentIds;
        return this;
    }

    public ChannelDefinitionQueryImpl parentDeploymentId(String parentDeploymentId) {
        if (parentDeploymentId == null) {
            throw new FlowableIllegalArgumentException("parentDeploymentId is null");
        }
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public ChannelDefinitionQueryImpl channelDefinitionKey(String key) {
        if (key == null) {
            throw new FlowableIllegalArgumentException("key is null");
        }
        this.key = key;
        return this;
    }

    public ChannelDefinitionQueryImpl channelDefinitionKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new FlowableIllegalArgumentException("keyLike is null");
        }
        this.keyLike = keyLike;
        return this;
    }

    public ChannelDefinitionQueryImpl channelVersion(Integer version) {
        this.checkVersion(version);
        this.version = version;
        return this;
    }

    public ChannelDefinitionQueryImpl channelVersionGreaterThan(Integer channelVersion) {
        this.checkVersion(channelVersion);
        this.versionGt = channelVersion;
        return this;
    }

    public ChannelDefinitionQueryImpl channelVersionGreaterThanOrEquals(Integer channelVersion) {
        this.checkVersion(channelVersion);
        this.versionGte = channelVersion;
        return this;
    }

    public ChannelDefinitionQueryImpl channelVersionLowerThan(Integer channelVersion) {
        this.checkVersion(channelVersion);
        this.versionLt = channelVersion;
        return this;
    }

    public ChannelDefinitionQueryImpl channelVersionLowerThanOrEquals(Integer channelVersion) {
        this.checkVersion(channelVersion);
        this.versionLte = channelVersion;
        return this;
    }

    protected void checkVersion(Integer version) {
        if (version == null) {
            throw new FlowableIllegalArgumentException("version is null");
        }
        if (version <= 0) {
            throw new FlowableIllegalArgumentException("version must be positive");
        }
    }

    public ChannelDefinitionQueryImpl latestVersion() {
        this.latest = true;
        return this;
    }

    public ChannelDefinitionQueryImpl channelCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public ChannelDefinitionQueryImpl channelCreateTimeAfter(Date createTimeAfter) {
        this.createTimeAfter = createTimeAfter;
        return this;
    }

    public ChannelDefinitionQueryImpl channelCreateTimeBefore(Date createTimeBefore) {
        this.createTimeBefore = createTimeBefore;
        return this;
    }

    public ChannelDefinitionQueryImpl channelDefinitionResourceName(String resourceName) {
        if (resourceName == null) {
            throw new FlowableIllegalArgumentException("resourceName is null");
        }
        this.resourceName = resourceName;
        return this;
    }

    public ChannelDefinitionQueryImpl channelDefinitionResourceNameLike(String resourceNameLike) {
        if (resourceNameLike == null) {
            throw new FlowableIllegalArgumentException("resourceNameLike is null");
        }
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    public ChannelDefinitionQueryImpl tenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("form tenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public ChannelDefinitionQueryImpl tenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("form tenantId is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public ChannelDefinitionQueryImpl withoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public ChannelDefinitionQuery orderByDeploymentId() {
        return (ChannelDefinitionQuery)this.orderBy(ChannelDefinitionQueryProperty.DEPLOYMENT_ID);
    }

    public ChannelDefinitionQuery orderByChannelDefinitionKey() {
        return (ChannelDefinitionQuery)this.orderBy(ChannelDefinitionQueryProperty.KEY);
    }

    public ChannelDefinitionQuery orderByChannelDefinitionCategory() {
        return (ChannelDefinitionQuery)this.orderBy(ChannelDefinitionQueryProperty.CATEGORY);
    }

    public ChannelDefinitionQuery orderByChannelDefinitionId() {
        return (ChannelDefinitionQuery)this.orderBy(ChannelDefinitionQueryProperty.ID);
    }

    public ChannelDefinitionQuery orderByChannelDefinitionName() {
        return (ChannelDefinitionQuery)this.orderBy(ChannelDefinitionQueryProperty.NAME);
    }

    public ChannelDefinitionQuery orderByCreateTime() {
        return (ChannelDefinitionQuery)this.orderBy(ChannelDefinitionQueryProperty.CREATE_TIME);
    }

    public ChannelDefinitionQuery orderByTenantId() {
        return (ChannelDefinitionQuery)this.orderBy(ChannelDefinitionQueryProperty.TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        return CommandContextUtil.getChannelDefinitionEntityManager(commandContext).findChannelDefinitionCountByQueryCriteria(this);
    }

    public List<ChannelDefinition> executeList(CommandContext commandContext) {
        return CommandContextUtil.getChannelDefinitionEntityManager(commandContext).findChannelDefinitionsByQueryCriteria(this);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Set<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getParentDeploymentId() {
        return this.parentDeploymentId;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getVersionGt() {
        return this.versionGt;
    }

    public Integer getVersionGte() {
        return this.versionGte;
    }

    public Integer getVersionLt() {
        return this.versionLt;
    }

    public Integer getVersionLte() {
        return this.versionLte;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getCreateTimeAfter() {
        return this.createTimeAfter;
    }

    public Date getCreateTimeBefore() {
        return this.createTimeBefore;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }
}

