/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.management;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.management.EventRegistryChangeDetectionManager;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.persistence.deploy.ChannelDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.deploy.EventDeploymentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventRegistryChangeDetectionManager
implements EventRegistryChangeDetectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventRegistryChangeDetectionManager.class);
    protected EventRegistryEngineConfiguration eventRegistryEngineConfiguration;

    public DefaultEventRegistryChangeDetectionManager(EventRegistryEngineConfiguration eventRegistryEngineConfiguration) {
        this.eventRegistryEngineConfiguration = eventRegistryEngineConfiguration;
    }

    public void detectChanges() {
        List channelDefinitions = this.eventRegistryEngineConfiguration.getEventRepositoryService().createChannelDefinitionQuery().latestVersion().list();
        HashSet<String> channelDefinitionCacheIds = new HashSet<String>();
        EventDeploymentManager deploymentManager = this.eventRegistryEngineConfiguration.getDeploymentManager();
        ArrayList cacheEntries = new ArrayList(deploymentManager.getChannelDefinitionCache().getAll());
        for (ChannelDefinitionCacheEntry channelDefinitionCacheEntry : cacheEntries) {
            channelDefinitionCacheIds.add(channelDefinitionCacheEntry.getChannelDefinitionEntity().getId());
        }
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            if (channelDefinitionCacheIds.contains(channelDefinition.getId())) continue;
            this.eventRegistryEngineConfiguration.getEventRepositoryService().getChannelModelById(channelDefinition.getId());
            LOGGER.info("Deployed channel definition with key {}", (Object)channelDefinition.getKey());
        }
        Set latestChannelDefinitionIds = channelDefinitions.stream().map(ChannelDefinition::getId).collect(Collectors.toSet());
        for (ChannelDefinitionCacheEntry channelDefinitionCacheEntry : cacheEntries) {
            if (latestChannelDefinitionIds.contains(channelDefinitionCacheEntry.getChannelDefinitionEntity().getId())) continue;
            deploymentManager.removeChannelDefinitionFromCache(channelDefinitionCacheEntry.getChannelDefinitionEntity());
        }
    }
}

