/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.RequestUtil;
import org.flowable.eventregistry.api.ChannelDefinitionQuery;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.ChannelDefinitionQueryProperty;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestApiInterceptor;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestResponseFactory;
import org.flowable.eventregistry.rest.service.api.repository.ChannelDefinitionResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Channel Definitions"}, description="Manage Channel Definitions", authorizations={@Authorization(value="basicAuth")})
public class ChannelDefinitionCollectionResource {
    private static final Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();
    @Autowired
    protected EventRegistryRestResponseFactory restResponseFactory;
    @Autowired
    protected EventRepositoryService repositoryService;
    @Autowired(required=false)
    protected EventRegistryRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="List of channel definitions", tags={"Channel Definitions"}, nickname="listChannelDefinitions")
    @ApiImplicitParams(value={@ApiImplicitParam(name="version", dataType="integer", value="Only return channel definitions with the given version.", paramType="query"), @ApiImplicitParam(name="name", dataType="string", value="Only return channel definitions with the given name.", paramType="query"), @ApiImplicitParam(name="nameLike", dataType="string", value="Only return channel definitions with a name like the given name.", paramType="query"), @ApiImplicitParam(name="key", dataType="string", value="Only return channel definitions with the given key.", paramType="query"), @ApiImplicitParam(name="keyLike", dataType="string", value="Only return channel definitions with a name like the given key.", paramType="query"), @ApiImplicitParam(name="createTime", dataType="date-time", value="Only return channel definitions with the given create time.", paramType="query"), @ApiImplicitParam(name="createTimeAfter", dataType="date-time", value="Only return channel definitions with a create time after the given date.", paramType="query"), @ApiImplicitParam(name="createTimeBefore", dataType="date-time", value="Only return channel definitions with a create time before the given date.", paramType="query"), @ApiImplicitParam(name="resourceName", dataType="string", value="Only return channel definitions with the given resource name.", paramType="query"), @ApiImplicitParam(name="resourceNameLike", dataType="string", value="Only return channel definitions with a name like the given resource name.", paramType="query"), @ApiImplicitParam(name="category", dataType="string", value="Only return channel definitions with the given category.", paramType="query"), @ApiImplicitParam(name="categoryLike", dataType="string", value="Only return channel definitions with a category like the given name.", paramType="query"), @ApiImplicitParam(name="categoryNotEquals", dataType="string", value="Only return channel definitions which do not have the given category.", paramType="query"), @ApiImplicitParam(name="deploymentId", dataType="string", value="Only return channel definitions with the given category.", paramType="query"), @ApiImplicitParam(name="latest", dataType="boolean", value="Only return the latest channel definition versions. Can only be used together with key and keyLike parameters, using any other parameter will result in a 400-response.", paramType="query"), @ApiImplicitParam(name="sort", dataType="string", value="Property to sort on, to be used together with the order.", allowableValues="name,id,key,category,deploymentId,version", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the channel definitions are returned"), @ApiResponse(code=400, message="Indicates a parameter was passed in the wrong format or that latest is used with other parameters other than key and keyLike. The status-message contains additional information.")})
    @GetMapping(value={"/event-registry-repository/channel-definitions"}, produces={"application/json"})
    public DataResponse<ChannelDefinitionResponse> getChannelDefinitions(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        Boolean latest;
        ChannelDefinitionQuery channelDefinitionQuery = this.repositoryService.createChannelDefinitionQuery();
        if (allRequestParams.containsKey("category")) {
            channelDefinitionQuery.channelCategory(allRequestParams.get("category"));
        }
        if (allRequestParams.containsKey("categoryLike")) {
            channelDefinitionQuery.channelCategoryLike(allRequestParams.get("categoryLike"));
        }
        if (allRequestParams.containsKey("categoryNotEquals")) {
            channelDefinitionQuery.channelCategoryNotEquals(allRequestParams.get("categoryNotEquals"));
        }
        if (allRequestParams.containsKey("key")) {
            channelDefinitionQuery.channelDefinitionKey(allRequestParams.get("key"));
        }
        if (allRequestParams.containsKey("keyLike")) {
            channelDefinitionQuery.channelDefinitionKeyLike(allRequestParams.get("keyLike"));
        }
        if (allRequestParams.containsKey("createTime")) {
            channelDefinitionQuery.channelCreateTime(RequestUtil.getDate(allRequestParams, (String)"createTime"));
        }
        if (allRequestParams.containsKey("createTimeAfter")) {
            channelDefinitionQuery.channelCreateTimeAfter(RequestUtil.getDate(allRequestParams, (String)"createTimeAfter"));
        }
        if (allRequestParams.containsKey("createTimeBefore")) {
            channelDefinitionQuery.channelCreateTimeBefore(RequestUtil.getDate(allRequestParams, (String)"createTimeBefore"));
        }
        if (allRequestParams.containsKey("name")) {
            channelDefinitionQuery.channelDefinitionName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            channelDefinitionQuery.channelDefinitionNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("resourceName")) {
            channelDefinitionQuery.channelDefinitionResourceName(allRequestParams.get("resourceName"));
        }
        if (allRequestParams.containsKey("resourceNameLike")) {
            channelDefinitionQuery.channelDefinitionResourceNameLike(allRequestParams.get("resourceNameLike"));
        }
        if (allRequestParams.containsKey("version")) {
            channelDefinitionQuery.channelVersion(Integer.valueOf(allRequestParams.get("version")));
        }
        if (allRequestParams.containsKey("latest") && (latest = Boolean.valueOf(allRequestParams.get("latest"))) != null && latest.booleanValue()) {
            channelDefinitionQuery.latestVersion();
        }
        if (allRequestParams.containsKey("deploymentId")) {
            channelDefinitionQuery.deploymentId(allRequestParams.get("deploymentId"));
        }
        if (allRequestParams.containsKey("tenantId")) {
            channelDefinitionQuery.tenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            channelDefinitionQuery.tenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessChannelDefinitionsWithQuery(channelDefinitionQuery);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)channelDefinitionQuery, (String)"name", properties, this.restResponseFactory::createChannelDefinitionResponseList);
    }

    static {
        properties.put("id", (QueryProperty)ChannelDefinitionQueryProperty.ID);
        properties.put("key", (QueryProperty)ChannelDefinitionQueryProperty.KEY);
        properties.put("category", (QueryProperty)ChannelDefinitionQueryProperty.CATEGORY);
        properties.put("name", (QueryProperty)ChannelDefinitionQueryProperty.NAME);
        properties.put("deploymentId", (QueryProperty)ChannelDefinitionQueryProperty.DEPLOYMENT_ID);
        properties.put("createTime", (QueryProperty)ChannelDefinitionQueryProperty.CREATE_TIME);
        properties.put("tenantId", (QueryProperty)ChannelDefinitionQueryProperty.TENANT_ID);
    }
}

