/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.common.rest.api.EngineInfoResponse;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngines;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestApiInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Event Registry Engine"}, description="Manage Event Registry Engine", authorizations={@Authorization(value="basicAuth")})
public class EventRegistryEngineResource {
    @Autowired(required=false)
    protected EventRegistryRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get engine info", tags={"Cmmn Engine"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the engine info is returned.")})
    @GetMapping(value={"/event-registry-management/engine"}, produces={"application/json"})
    public EngineInfoResponse getEngineInfo() {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessManagementInfo();
        }
        EventRegistryEngine eventRegistryEngine = EventRegistryEngines.getDefaultEventRegistryEngine();
        EngineInfoResponse response = new EngineInfoResponse();
        response.setName(eventRegistryEngine.getName());
        response.setVersion(EventRegistryEngine.class.getPackage().getImplementationVersion());
        return response;
    }
}

