/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.scripting;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.scripting.ScriptEngineRequest;
import org.flowable.common.engine.impl.scripting.ScriptingEngines;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.Condition;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ScriptCondition
implements Condition {
    private final String expression;
    private final String language;

    public ScriptCondition(String expression, String language) {
        this.expression = expression;
        this.language = language;
    }

    @Override
    public boolean evaluate(String sequenceFlowId, DelegateExecution execution) {
        ScriptEngineRequest.Builder builder;
        ScriptingEngines scriptingEngines = CommandContextUtil.getProcessEngineConfiguration().getScriptingEngines();
        Object result = scriptingEngines.evaluate((builder = ScriptEngineRequest.builder().script(this.expression).language(this.language).variableContainer((VariableContainer)execution)).build()).getResult();
        if (result == null) {
            throw new FlowableException("condition script returns null: " + this.expression);
        }
        if (!(result instanceof Boolean)) {
            throw new FlowableException("condition script returns non-Boolean: " + result + " (" + result.getClass().getName() + ")");
        }
        return (Boolean)result;
    }
}

