/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminateEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminateEndEventActivityBehavior.class);
    private static final long serialVersionUID = 1L;
    protected boolean terminateAll;
    protected boolean terminateMultiInstance;

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        executionEntityManager.deleteExecutionAndRelatedData(executionEntity, this.createDeleteReason(executionEntity.getCurrentActivityId()), false);
        if (this.terminateAll) {
            this.terminateAllBehaviour(executionEntity, commandContext, executionEntityManager);
        } else if (this.terminateMultiInstance) {
            this.terminateMultiInstanceRoot(executionEntity, commandContext, executionEntityManager);
        } else {
            this.defaultTerminateEndEventBehaviour(executionEntity, commandContext, executionEntityManager);
        }
    }

    protected void terminateAllBehaviour(ExecutionEntity execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity rootExecutionEntity = executionEntityManager.findByRootProcessInstanceId(execution.getRootProcessInstanceId());
        String deleteReason = this.createDeleteReason(execution.getCurrentActivityId());
        this.deleteExecutionEntities(executionEntityManager, rootExecutionEntity, execution, deleteReason);
        this.endAllHistoricActivities(rootExecutionEntity.getId(), deleteReason);
        CommandContextUtil.getHistoryManager(commandContext).recordProcessInstanceEnd(rootExecutionEntity, deleteReason, execution.getCurrentActivityId(), CommandContextUtil.getProcessEngineConfiguration(commandContext).getClock().getCurrentTime());
    }

    protected void defaultTerminateEndEventBehaviour(ExecutionEntity execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity scopeExecutionEntity = executionEntityManager.findFirstScope(execution);
        String deleteReason = this.createDeleteReason(execution.getCurrentActivityId());
        if (scopeExecutionEntity.isProcessInstanceType() && scopeExecutionEntity.getSuperExecutionId() == null) {
            this.endAllHistoricActivities(scopeExecutionEntity.getId(), deleteReason);
            this.deleteExecutionEntities(executionEntityManager, scopeExecutionEntity, execution, deleteReason);
            CommandContextUtil.getHistoryManager(commandContext).recordProcessInstanceEnd(scopeExecutionEntity, deleteReason, execution.getCurrentActivityId(), CommandContextUtil.getProcessEngineConfiguration(commandContext).getClock().getCurrentTime());
        } else if (scopeExecutionEntity.getCurrentFlowElement() != null && scopeExecutionEntity.getCurrentFlowElement() instanceof SubProcess) {
            SubProcess subProcess = (SubProcess)scopeExecutionEntity.getCurrentFlowElement();
            scopeExecutionEntity.setDeleteReason(deleteReason);
            if (subProcess.hasMultiInstanceLoopCharacteristics()) {
                CommandContextUtil.getAgenda(commandContext).planDestroyScopeOperation(scopeExecutionEntity);
                MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)subProcess.getBehavior();
                multiInstanceBehavior.leave(scopeExecutionEntity);
            } else {
                CommandContextUtil.getAgenda(commandContext).planDestroyScopeOperation(scopeExecutionEntity);
                ExecutionEntity outgoingFlowExecution = executionEntityManager.createChildExecution(scopeExecutionEntity.getParent());
                outgoingFlowExecution.setCurrentFlowElement(scopeExecutionEntity.getCurrentFlowElement());
                CommandContextUtil.getAgenda(commandContext).planTakeOutgoingSequenceFlowsOperation(outgoingFlowExecution, true);
            }
        } else if (scopeExecutionEntity.getParentId() == null && scopeExecutionEntity.getSuperExecutionId() != null) {
            ExecutionEntity callActivityExecution = scopeExecutionEntity.getSuperExecution();
            CallActivity callActivity = (CallActivity)callActivityExecution.getCurrentFlowElement();
            SubProcessActivityBehavior subProcessActivityBehavior = null;
            subProcessActivityBehavior = (SubProcessActivityBehavior)callActivity.getBehavior();
            try {
                subProcessActivityBehavior.completing(callActivityExecution, scopeExecutionEntity);
            }
            catch (RuntimeException e) {
                LOGGER.error("Error while completing sub process of execution {}", (Object)scopeExecutionEntity, (Object)e);
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Error while completing sub process of execution {}", (Object)scopeExecutionEntity, (Object)e);
                throw new FlowableException("Error while completing sub process of execution " + scopeExecutionEntity, (Throwable)e);
            }
            if (callActivity.hasMultiInstanceLoopCharacteristics()) {
                this.sendProcessInstanceCompletedEvent(scopeExecutionEntity, execution.getCurrentFlowElement());
                MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)callActivity.getBehavior();
                multiInstanceBehavior.leave(callActivityExecution);
                executionEntityManager.deleteProcessInstanceExecutionEntity(scopeExecutionEntity.getId(), execution.getCurrentFlowElement().getId(), "terminate end event", false, false, false);
            } else {
                this.sendProcessInstanceCompletedEvent(scopeExecutionEntity, execution.getCurrentFlowElement());
                executionEntityManager.deleteProcessInstanceExecutionEntity(scopeExecutionEntity.getId(), execution.getCurrentFlowElement().getId(), "terminate end event", false, false, false);
                ExecutionEntity superExecutionEntity = (ExecutionEntity)executionEntityManager.findById(scopeExecutionEntity.getSuperExecutionId());
                CommandContextUtil.getAgenda(commandContext).planTakeOutgoingSequenceFlowsOperation(superExecutionEntity, true);
            }
        }
    }

    protected void endAllHistoricActivities(String processInstanceId, String deleteReason) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (!processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            return;
        }
        List<HistoricActivityInstanceEntity> historicActivityInstances = processEngineConfiguration.getHistoricActivityInstanceEntityManager().findUnfinishedHistoricActivityInstancesByProcessInstanceId(processInstanceId);
        Clock clock = processEngineConfiguration.getClock();
        for (HistoricActivityInstanceEntity historicActivityInstance : historicActivityInstances) {
            historicActivityInstance.markEnded(deleteReason, clock.getCurrentTime());
            FlowableEventDispatcher eventDispatcher = null;
            if (processEngineConfiguration != null) {
                eventDispatcher = processEngineConfiguration.getEventDispatcher();
            }
            if (eventDispatcher == null || !eventDispatcher.isEnabled()) continue;
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstance), processEngineConfiguration.getEngineCfgKey());
        }
    }

    protected void terminateMultiInstanceRoot(ExecutionEntity execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity miRootExecutionEntity = executionEntityManager.findFirstMultiInstanceRoot(execution);
        if (miRootExecutionEntity != null) {
            ExecutionEntity siblingExecution = executionEntityManager.createChildExecution(miRootExecutionEntity.getParent());
            siblingExecution.setCurrentFlowElement(miRootExecutionEntity.getCurrentFlowElement());
            this.deleteExecutionEntities(executionEntityManager, miRootExecutionEntity, execution, this.createDeleteReason(miRootExecutionEntity.getActivityId()));
            CommandContextUtil.getAgenda(commandContext).planTakeOutgoingSequenceFlowsOperation(siblingExecution, true);
        } else {
            this.defaultTerminateEndEventBehaviour(execution, commandContext, executionEntityManager);
        }
    }

    protected void deleteExecutionEntities(ExecutionEntityManager executionEntityManager, ExecutionEntity rootExecutionEntity, ExecutionEntity executionAtTerminateEndEvent, String deleteReason) {
        FlowElement terminateEndEvent = executionAtTerminateEndEvent.getCurrentFlowElement();
        List<ExecutionEntity> childExecutions = executionEntityManager.collectChildren(rootExecutionEntity);
        for (ExecutionEntity childExecution : childExecutions) {
            if (!childExecution.isProcessInstanceType()) continue;
            this.sendProcessInstanceCompletedEvent(childExecution, terminateEndEvent);
        }
        CommandContextUtil.getExecutionEntityManager().deleteChildExecutions(rootExecutionEntity, null, null, deleteReason, true, terminateEndEvent);
        this.sendProcessInstanceCompletedEvent(rootExecutionEntity, terminateEndEvent);
        executionEntityManager.deleteExecutionAndRelatedData(rootExecutionEntity, deleteReason, false);
    }

    protected void sendProcessInstanceCompletedEvent(ExecutionEntity execution, FlowElement terminateEndEvent) {
        Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId());
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        processEngineConfiguration.getListenerNotificationHelper().executeExecutionListeners((HasExecutionListeners)process, execution, "end");
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled() && (execution.isProcessInstanceType() && execution.getSuperExecutionId() == null || execution.getParentId() == null && execution.getSuperExecutionId() != null)) {
            boolean fireEvent = true;
            if (!this.terminateAll) {
                Process processForExecution = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId());
                Process processForTerminateEndEvent = this.getProcessForTerminateEndEvent(terminateEndEvent);
                fireEvent = processForExecution.getId().equals(processForTerminateEndEvent.getId());
            }
            if (fireEvent) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createTerminateEvent(execution, terminateEndEvent), processEngineConfiguration.getEngineCfgKey());
            }
        }
    }

    protected Process getProcessForTerminateEndEvent(FlowElement terminateEndEvent) {
        FlowElementsContainer parent = terminateEndEvent.getParentContainer();
        while (!(parent instanceof Process)) {
            SubProcess subProcess = (SubProcess)parent;
            parent = subProcess.getParentContainer();
        }
        return (Process)parent;
    }

    protected String createDeleteReason(String activityId) {
        return "terminate end event (" + activityId + ")";
    }

    public boolean isTerminateAll() {
        return this.terminateAll;
    }

    public void setTerminateAll(boolean terminateAll) {
        this.terminateAll = terminateAll;
    }

    public boolean isTerminateMultiInstance() {
        return this.terminateMultiInstance;
    }

    public void setTerminateMultiInstance(boolean terminateMultiInstance) {
        this.terminateMultiInstance = terminateMultiInstance;
    }
}

