/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Escalation;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public class EscalationPropagation {
    public static void propagateEscalation(Escalation escalation, DelegateExecution execution) {
        EscalationPropagation.propagateEscalation(escalation.getEscalationCode(), escalation.getName(), execution);
    }

    public static void propagateEscalation(String escalationCode, String escalationName, DelegateExecution execution) {
        HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
        HashSet<String> rootProcessDefinitionIds = new HashSet<String>();
        if (!execution.getProcessInstanceId().equals(execution.getRootProcessInstanceId())) {
            ExecutionEntity parentExecution = (ExecutionEntity)execution;
            while (parentExecution.getParentId() != null || parentExecution.getSuperExecutionId() != null) {
                if (parentExecution.getParentId() != null) {
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                parentExecution = parentExecution.getSuperExecution();
                rootProcessDefinitionIds.add(parentExecution.getProcessDefinitionId());
            }
        }
        if (rootProcessDefinitionIds.size() > 0) {
            for (String processDefinitionId : rootProcessDefinitionIds) {
                eventMap.putAll(EscalationPropagation.findCatchingEventsForProcess(processDefinitionId, escalationCode));
            }
        }
        eventMap.putAll(EscalationPropagation.findCatchingEventsForProcess(execution.getProcessDefinitionId(), escalationCode));
        if (eventMap.size() > 0) {
            EscalationPropagation.executeCatch(eventMap, execution, escalationCode, escalationName);
        }
    }

    protected static void executeCatch(Map<String, List<Event>> eventMap, DelegateExecution delegateExecution, String escalationCode, String escalationName) {
        HashSet<String> toDeleteProcessInstanceIds = new HashSet<String>();
        Event matchingEvent = null;
        ExecutionEntity currentExecution = (ExecutionEntity)delegateExecution;
        ExecutionEntity parentExecution = null;
        if (eventMap.containsKey(currentExecution.getActivityId() + "#" + currentExecution.getProcessDefinitionId())) {
            parentExecution = currentExecution.getParentId() != null && currentExecution.getParent().isMultiInstanceRoot() ? currentExecution.getParent() : currentExecution;
            matchingEvent = EscalationPropagation.getCatchEventFromList(eventMap.get(currentExecution.getActivityId() + "#" + currentExecution.getProcessDefinitionId()), parentExecution);
        } else {
            parentExecution = currentExecution.getParent();
            while (matchingEvent == null && parentExecution != null) {
                FlowElementsContainer currentContainer = null;
                if (parentExecution.getCurrentFlowElement() instanceof FlowElementsContainer) {
                    currentContainer = (FlowElementsContainer)parentExecution.getCurrentFlowElement();
                } else if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                    currentContainer = ProcessDefinitionUtil.getProcess(parentExecution.getProcessDefinitionId());
                }
                if (currentContainer != null) {
                    for (String refId : eventMap.keySet()) {
                        EscalationEventDefinition escalationEventDef;
                        List<Event> events = eventMap.get(refId);
                        if (!CollectionUtil.isNotEmpty(events) || !(events.get(0) instanceof StartEvent)) continue;
                        String refActivityId = refId.substring(0, refId.indexOf(35));
                        String refProcessDefinitionId = refId.substring(refId.indexOf(35) + 1);
                        if (!parentExecution.getProcessDefinitionId().equals(refProcessDefinitionId) || currentContainer.getFlowElement(refActivityId) == null || !StringUtils.isNotEmpty((CharSequence)(escalationEventDef = EscalationPropagation.getEscalationEventDefinition(matchingEvent = EscalationPropagation.getCatchEventFromList(events, parentExecution))).getEscalationCode())) continue;
                        break;
                    }
                }
                if (matchingEvent != null) continue;
                if (eventMap.containsKey(parentExecution.getActivityId() + "#" + parentExecution.getProcessDefinitionId())) {
                    if (parentExecution.getParentId() != null && parentExecution.getParent().isMultiInstanceRoot()) {
                        parentExecution = parentExecution.getParent();
                    }
                    matchingEvent = EscalationPropagation.getCatchEventFromList(eventMap.get(parentExecution.getActivityId() + "#" + parentExecution.getProcessDefinitionId()), parentExecution);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)parentExecution.getParentId())) {
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                if (!parentExecution.getProcessInstanceId().equals(parentExecution.getRootProcessInstanceId())) {
                    toDeleteProcessInstanceIds.add(parentExecution.getProcessInstanceId());
                    parentExecution = parentExecution.getSuperExecution();
                    continue;
                }
                parentExecution = null;
            }
        }
        if (matchingEvent != null && parentExecution != null) {
            for (String processInstanceId : toDeleteProcessInstanceIds) {
                ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
                ExecutionEntity processInstanceEntity = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
                ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
                FlowableEventDispatcher eventDispatcher = null;
                if (processEngineConfiguration != null) {
                    eventDispatcher = processEngineConfiguration.getEventDispatcher();
                }
                if (eventDispatcher == null || !eventDispatcher.isEnabled()) continue;
                processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_COMPLETED_WITH_ESCALATION_END_EVENT, processInstanceEntity), processEngineConfiguration.getEngineCfgKey());
            }
            EscalationPropagation.executeEventHandler(matchingEvent, parentExecution, currentExecution, escalationCode, escalationName);
        }
    }

    protected static void executeEventHandler(Event event, ExecutionEntity parentExecution, ExecutionEntity currentExecution, String escalationCode, String escalationName) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        FlowableEventDispatcher eventDispatcher = null;
        if (processEngineConfiguration != null) {
            eventDispatcher = processEngineConfiguration.getEventDispatcher();
        }
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEscalationEvent(FlowableEngineEventType.ACTIVITY_ESCALATION_RECEIVED, event.getId(), escalationCode, escalationName, parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId()), processEngineConfiguration.getEngineCfgKey());
        }
        if (event instanceof StartEvent) {
            ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
            ExecutionEntity eventSubProcessExecution = executionEntityManager.createChildExecution(parentExecution);
            eventSubProcessExecution.setCurrentFlowElement((FlowElement)(event.getSubProcess() != null ? event.getSubProcess() : event));
            CommandContextUtil.getAgenda().planContinueProcessOperation(eventSubProcessExecution);
        } else {
            ExecutionEntity boundaryExecution = null;
            List<? extends ExecutionEntity> childExecutions = parentExecution.getExecutions();
            for (ExecutionEntity executionEntity : childExecutions) {
                if (executionEntity == null || executionEntity.getActivityId() == null || !executionEntity.getActivityId().equals(event.getId())) continue;
                boundaryExecution = executionEntity;
            }
            if (boundaryExecution != null && boundaryExecution.isSuspended()) {
                String errorMessage = String.format("Cannot propagate escalation '%s' with code '%s', because execution '%s' is suspended.", escalationName, escalationCode, boundaryExecution.getId());
                throw new FlowableException(errorMessage);
            }
            CommandContextUtil.getAgenda().planTriggerExecutionOperation(boundaryExecution);
        }
    }

    protected static Map<String, List<Event>> findCatchingEventsForProcess(String processDefinitionId, String escalationCode) {
        HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        List subProcesses = process.findFlowElementsOfType(EventSubProcess.class, true);
        for (EventSubProcess eventSubProcess : subProcesses) {
            for (FlowElement flowElement : eventSubProcess.getFlowElements()) {
                StartEvent startEvent;
                if (!(flowElement instanceof StartEvent) || !CollectionUtil.isNotEmpty((Collection)(startEvent = (StartEvent)flowElement).getEventDefinitions()) || !(startEvent.getEventDefinitions().get(0) instanceof EscalationEventDefinition)) continue;
                EscalationEventDefinition escalationEventDef = (EscalationEventDefinition)startEvent.getEventDefinitions().get(0);
                String eventEscalationCode = null;
                eventEscalationCode = StringUtils.isNotEmpty((CharSequence)escalationEventDef.getEscalationCode()) && bpmnModel.containsEscalationRef(escalationEventDef.getEscalationCode()) ? bpmnModel.getEscalation(escalationEventDef.getEscalationCode()).getEscalationCode() : escalationEventDef.getEscalationCode();
                if (eventEscalationCode != null && escalationCode != null && !eventEscalationCode.equals(escalationCode)) continue;
                ArrayList<StartEvent> startEvents = new ArrayList<StartEvent>();
                startEvents.add(startEvent);
                eventMap.put(eventSubProcess.getId() + "#" + processDefinitionId, startEvents);
            }
        }
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (boundaryEvent.getAttachedToRefId() == null || !CollectionUtil.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof EscalationEventDefinition)) continue;
            EscalationEventDefinition escalationEventDef = (EscalationEventDefinition)boundaryEvent.getEventDefinitions().get(0);
            String eventEscalationCode = null;
            eventEscalationCode = StringUtils.isNotEmpty((CharSequence)escalationEventDef.getEscalationCode()) && bpmnModel.containsEscalationRef(escalationEventDef.getEscalationCode()) ? bpmnModel.getEscalation(escalationEventDef.getEscalationCode()).getEscalationCode() : escalationEventDef.getEscalationCode();
            if (eventEscalationCode != null && escalationCode != null && !eventEscalationCode.equals(escalationCode)) continue;
            List<BoundaryEvent> elementBoundaryEvents = null;
            if (!eventMap.containsKey(boundaryEvent.getAttachedToRefId() + "#" + processDefinitionId)) {
                elementBoundaryEvents = new ArrayList();
                eventMap.put(boundaryEvent.getAttachedToRefId() + "#" + processDefinitionId, elementBoundaryEvents);
            } else {
                elementBoundaryEvents = (List)eventMap.get(boundaryEvent.getAttachedToRefId() + "#" + processDefinitionId);
            }
            elementBoundaryEvents.add(boundaryEvent);
        }
        return eventMap;
    }

    protected static Event getCatchEventFromList(List<Event> events, ExecutionEntity parentExecution) {
        Event selectedEvent = null;
        String selectedEventEscalationCode = null;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId());
        for (Event event : events) {
            EscalationEventDefinition escalationEventDef = EscalationPropagation.getEscalationEventDefinition(event);
            String escalationCode = escalationEventDef.getEscalationCode();
            if (bpmnModel != null) {
                escalationCode = StringUtils.isNotEmpty((CharSequence)escalationEventDef.getEscalationCode()) && bpmnModel.containsEscalationRef(escalationEventDef.getEscalationCode()) ? bpmnModel.getEscalation(escalationEventDef.getEscalationCode()).getEscalationCode() : escalationEventDef.getEscalationCode();
            }
            if (selectedEvent != null && (!StringUtils.isEmpty(selectedEventEscalationCode) || !StringUtils.isNotEmpty((CharSequence)escalationCode))) continue;
            selectedEvent = event;
            selectedEventEscalationCode = escalationCode;
        }
        return selectedEvent;
    }

    protected static EscalationEventDefinition getEscalationEventDefinition(Event event) {
        for (EventDefinition eventDefinition : event.getEventDefinitions()) {
            if (!(eventDefinition instanceof EscalationEventDefinition)) continue;
            return (EscalationEventDefinition)eventDefinition;
        }
        return null;
    }
}

