/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import org.flowable.batch.api.BatchQuery;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class BpmnHistoryCleanupJobHandler
implements JobHandler {
    public static final String TYPE = "bpmn-history-cleanup";
    private static final String DEFAULT_BATCH_NAME = "Flowable BPMN History Cleanup";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        int batchSize = processEngineConfiguration.getCleanInstancesBatchSize();
        HistoricProcessInstanceQuery query = processEngineConfiguration.getHistoryCleaningManager().createHistoricProcessInstanceCleaningQuery();
        if (processEngineConfiguration.isCleanInstancesSequentially()) {
            query.deleteSequentiallyUsingBatch(batchSize, DEFAULT_BATCH_NAME);
        } else {
            query.deleteInParallelUsingBatch(batchSize, DEFAULT_BATCH_NAME);
        }
        BatchQuery batchCleaningQuery = processEngineConfiguration.getHistoryCleaningManager().createBatchCleaningQuery();
        if (batchCleaningQuery != null) {
            batchCleaningQuery.deleteWithRelatedData();
        }
    }
}

