/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.calendar.DurationHelper;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.runtime.ClockReader;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobService;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRetryCmd
implements Command<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JobRetryCmd.class.getName());
    protected String jobId;
    protected Throwable exception;

    public JobRetryCmd(String jobId, Throwable exception) {
        this.jobId = jobId;
        this.exception = exception;
    }

    public Object execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration;
        FlowableEventDispatcher eventDispatcher;
        ProcessEngineConfigurationImpl processEngineConfig = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        JobService jobService = processEngineConfig.getJobServiceConfiguration().getJobService();
        TimerJobService timerJobService = processEngineConfig.getJobServiceConfiguration().getTimerJobService();
        JobEntity job = jobService.findJobById(this.jobId);
        if (job == null) {
            return null;
        }
        ExecutionEntity executionEntity = this.fetchExecutionEntity(commandContext, job.getExecutionId());
        FlowElement currentFlowElement = executionEntity != null ? executionEntity.getCurrentFlowElement() : null;
        String failedJobRetryTimeCycleValue = null;
        if (currentFlowElement instanceof ServiceTask) {
            failedJobRetryTimeCycleValue = ((ServiceTask)currentFlowElement).getFailedJobRetryTimeCycleValue();
        }
        if (executionEntity != null) {
            Expression expression;
            Object value;
            ExpressionManager expressionManager;
            executionEntity.setActive(false);
            if (StringUtils.isNotEmpty((CharSequence)failedJobRetryTimeCycleValue) && (expressionManager = processEngineConfig.getExpressionManager()) != null && (value = (expression = expressionManager.createExpression(failedJobRetryTimeCycleValue)).getValue((VariableContainer)executionEntity)) != null) {
                failedJobRetryTimeCycleValue = value.toString();
            }
        }
        AbstractRuntimeJobEntity newJobEntity = null;
        if (currentFlowElement == null || failedJobRetryTimeCycleValue == null) {
            LOGGER.debug("activity or FailedJobRetryTimerCycleValue is null in job {}. Only decrementing retries.", (Object)this.jobId);
            newJobEntity = job.getRetries() <= 1 ? jobService.moveJobToDeadLetterJob((AbstractRuntimeJobEntity)job) : timerJobService.moveJobToTimerJob(job);
            newJobEntity.setRetries(job.getRetries() - 1);
            if (job.getDuedate() == null || "message".equals(job.getJobType())) {
                newJobEntity.setDuedate(this.calculateDueDate(commandContext, processEngineConfig.getAsyncFailedJobWaitTime(), null));
            } else {
                newJobEntity.setDuedate(this.calculateDueDate(commandContext, processEngineConfig.getDefaultFailedJobWaitTime(), job.getDuedate()));
            }
        } else {
            try {
                DurationHelper durationHelper = new DurationHelper(failedJobRetryTimeCycleValue, (ClockReader)processEngineConfig.getClock());
                int jobRetries = job.getRetries();
                if (job.getExceptionMessage() == null) {
                    jobRetries = durationHelper.getTimes();
                }
                newJobEntity = jobRetries <= 1 ? jobService.moveJobToDeadLetterJob((AbstractRuntimeJobEntity)job) : timerJobService.moveJobToTimerJob(job);
                newJobEntity.setDuedate(durationHelper.getDateAfter());
                if (job.getExceptionMessage() == null) {
                    LOGGER.debug("Applying JobRetryStrategy '{}' the first time for job {} with {} retries", new Object[]{failedJobRetryTimeCycleValue, job.getId(), durationHelper.getTimes()});
                } else {
                    LOGGER.debug("Decrementing retries of JobRetryStrategy '{}' for job {}", (Object)failedJobRetryTimeCycleValue, (Object)job.getId());
                }
                newJobEntity.setRetries(jobRetries - 1);
            }
            catch (Exception e) {
                throw new FlowableException("failedJobRetryTimeCycle has wrong format:" + failedJobRetryTimeCycleValue, this.exception);
            }
        }
        if (this.exception != null) {
            newJobEntity.setExceptionMessage(this.exception.getMessage());
            newJobEntity.setExceptionStacktrace(this.getExceptionStacktrace());
        }
        if ((eventDispatcher = (processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext)).getEventDispatcher()) != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, newJobEntity), processEngineConfiguration.getEngineCfgKey());
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_RETRIES_DECREMENTED, newJobEntity), processEngineConfiguration.getEngineCfgKey());
        }
        return null;
    }

    protected Date calculateDueDate(CommandContext commandContext, int waitTimeInSeconds, Date oldDate) {
        GregorianCalendar newDateCal = new GregorianCalendar();
        if (oldDate != null) {
            newDateCal.setTime(oldDate);
        } else {
            newDateCal.setTime(CommandContextUtil.getProcessEngineConfiguration(commandContext).getClock().getCurrentTime());
        }
        ((Calendar)newDateCal).add(13, waitTimeInSeconds);
        return newDateCal.getTime();
    }

    protected String getExceptionStacktrace() {
        StringWriter stringWriter = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    protected ExecutionEntity fetchExecutionEntity(CommandContext commandContext, String executionId) {
        if (executionId == null) {
            return null;
        }
        return (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(executionId);
    }
}

