/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.Execution;

public class GetExecutionVariablesCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected Collection<String> variableNames;
    protected boolean isLocal;

    public GetExecutionVariablesCmd(String executionId, Collection<String> variableNames, boolean isLocal) {
        this.executionId = executionId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new FlowableIllegalArgumentException("executionId is null");
        }
        ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.executionId);
        if (execution == null) {
            throw new FlowableObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            return compatibilityHandler.getExecutionVariables(this.executionId, this.variableNames, this.isLocal);
        }
        if (this.variableNames == null || this.variableNames.isEmpty()) {
            if (this.isLocal) {
                return execution.getVariablesLocal();
            }
            return execution.getVariables();
        }
        if (this.isLocal) {
            return execution.getVariablesLocal(this.variableNames, false);
        }
        return execution.getVariables(this.variableNames, false);
    }
}

