/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.migration.ProcessInstanceBatchMigrationPartResult;
import org.flowable.engine.migration.ProcessInstanceBatchMigrationResult;

public class GetProcessInstanceMigrationBatchResultCmd
implements Command<ProcessInstanceBatchMigrationResult> {
    public static final String BATCH_RESULT_STATUS_LABEL = "resultStatus";
    public static final String BATCH_RESULT_MESSAGE_LABEL = "resultMessage";
    protected String batchId;

    public GetProcessInstanceMigrationBatchResultCmd(String batchId) {
        this.batchId = batchId;
    }

    public ProcessInstanceBatchMigrationResult execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        BatchService batchService = processEngineConfiguration.getBatchServiceConfiguration().getBatchService();
        Batch batch = batchService.getBatch(this.batchId);
        if (batch != null) {
            ObjectMapper objectMapper = processEngineConfiguration.getObjectMapper();
            ProcessInstanceBatchMigrationResult result = this.convertFromBatch(batch, objectMapper);
            List batchParts = batchService.findBatchPartsByBatchId(batch.getId());
            if (batchParts != null && !batchParts.isEmpty()) {
                for (BatchPart batchPart : batchParts) {
                    result.addMigrationPart(this.convertFromBatchPart(batchPart, objectMapper));
                }
            }
            return result;
        }
        return null;
    }

    protected ProcessInstanceBatchMigrationResult convertFromBatch(Batch batch, ObjectMapper objectMapper) {
        ProcessInstanceBatchMigrationResult result = new ProcessInstanceBatchMigrationResult();
        result.setBatchId(batch.getId());
        result.setSourceProcessDefinitionId(batch.getBatchSearchKey());
        result.setTargetProcessDefinitionId(batch.getBatchSearchKey2());
        result.setStatus(batch.getStatus());
        return result;
    }

    protected ProcessInstanceBatchMigrationPartResult convertFromBatchPart(BatchPart batchPart, ObjectMapper objectMapper) {
        ProcessInstanceBatchMigrationPartResult partResult = new ProcessInstanceBatchMigrationPartResult();
        partResult.setBatchId(batchPart.getId());
        partResult.setProcessInstanceId(batchPart.getScopeId());
        partResult.setSourceProcessDefinitionId(batchPart.getBatchSearchKey());
        partResult.setTargetProcessDefinitionId(batchPart.getBatchSearchKey2());
        if (batchPart.getCompleteTime() != null) {
            partResult.setStatus("completed");
        }
        partResult.setResult(batchPart.getStatus());
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if ("fail".equals(batchPart.getStatus()) && batchPart.getResultDocumentJson(processEngineConfiguration.getEngineCfgKey()) != null) {
            try {
                JsonNode resultNode = objectMapper.readTree(batchPart.getResultDocumentJson(processEngineConfiguration.getEngineCfgKey()));
                if (resultNode.has(BATCH_RESULT_MESSAGE_LABEL)) {
                    String resultMessage = resultNode.get(BATCH_RESULT_MESSAGE_LABEL).asText();
                    partResult.setMigrationMessage(resultMessage);
                }
            }
            catch (IOException e) {
                throw new FlowableException("Error reading batch part " + batchPart.getId());
            }
        }
        return partResult;
    }
}

