/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.DynamicPropertyUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.EntityLinkUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.interceptor.StartSubProcessInstanceAfterContext;
import org.flowable.engine.interceptor.StartSubProcessInstanceBeforeContext;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallActivityBehavior.class);
    private static final long serialVersionUID = 1L;
    private static final String EXPRESSION_REGEX = "\\$+\\{+.+\\}";
    public static final String CALLED_ELEMENT_TYPE_KEY = "key";
    public static final String CALLED_ELEMENT_TYPE_ID = "id";
    protected CallActivity callActivity;
    protected String calledElementType;
    protected Boolean fallbackToDefaultTenant;
    protected List<MapExceptionEntry> mapExceptions;

    public CallActivityBehavior(CallActivity callActivity) {
        this.callActivity = callActivity;
        this.calledElementType = callActivity.getCalledElementType();
        this.mapExceptions = callActivity.getMapExceptions();
        this.fallbackToDefaultTenant = callActivity.getFallbackToDefaultTenant();
    }

    @Override
    public void execute(DelegateExecution execution) {
        Expression expression;
        String idVariableName;
        CommandContext commandContext;
        ProcessEngineConfigurationImpl processEngineConfiguration;
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CallActivity callActivity = (CallActivity)executionEntity.getCurrentFlowElement();
        ProcessDefinition processDefinition = this.getProcessDefinition(execution, callActivity, processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext = CommandContextUtil.getCommandContext()));
        Process subProcess = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        if (subProcess == null) {
            throw new FlowableException("Cannot start a sub process instance. Process model " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") could not be found");
        }
        FlowElement initialFlowElement = subProcess.getInitialFlowElement();
        if (initialFlowElement == null) {
            throw new FlowableException("No start element found for process definition " + processDefinition.getId());
        }
        if (ProcessDefinitionUtil.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new FlowableException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        String businessKey = null;
        if (!StringUtils.isEmpty((CharSequence)callActivity.getBusinessKey())) {
            Expression expression2 = expressionManager.createExpression(callActivity.getBusinessKey());
            businessKey = expression2.getValue((VariableContainer)execution).toString();
        } else if (callActivity.isInheritBusinessKey()) {
            ExecutionEntity processInstance = (ExecutionEntity)executionEntityManager.findById(execution.getProcessInstanceId());
            businessKey = processInstance.getBusinessKey();
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        StartSubProcessInstanceBeforeContext instanceBeforeContext = new StartSubProcessInstanceBeforeContext(businessKey, callActivity.getProcessInstanceName(), variables, executionEntity, callActivity.getInParameters(), callActivity.isInheritVariables(), initialFlowElement.getId(), initialFlowElement, subProcess, processDefinition);
        if (processEngineConfiguration.getStartProcessInstanceInterceptor() != null) {
            processEngineConfiguration.getStartProcessInstanceInterceptor().beforeStartSubProcessInstance(instanceBeforeContext);
        }
        ExecutionEntity subProcessInstance = processEngineConfiguration.getExecutionEntityManager().createSubprocessInstance(instanceBeforeContext.getProcessDefinition(), instanceBeforeContext.getCallActivityExecution(), instanceBeforeContext.getBusinessKey(), instanceBeforeContext.getInitialActivityId());
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_CREATED, subProcessInstance), processEngineConfiguration.getEngineCfgKey());
        }
        subProcessInstance.setVariables(this.processDataObjects(subProcess.getDataObjects()));
        if (instanceBeforeContext.isInheritVariables()) {
            Map executionVariables = execution.getVariables();
            for (Map.Entry entry : executionVariables.entrySet()) {
                instanceBeforeContext.getVariables().put((String)entry.getKey(), entry.getValue());
            }
        }
        for (IOParameter inParameter : instanceBeforeContext.getInParameters()) {
            Object value = null;
            if (StringUtils.isNotEmpty((CharSequence)inParameter.getSourceExpression())) {
                Expression expression3 = expressionManager.createExpression(inParameter.getSourceExpression().trim());
                value = expression3.getValue((VariableContainer)execution);
            } else {
                value = execution.getVariable(inParameter.getSource());
            }
            String variableName = null;
            if (StringUtils.isNotEmpty((CharSequence)inParameter.getTargetExpression())) {
                Expression expression4 = expressionManager.createExpression(inParameter.getTargetExpression());
                Object variableNameValue = expression4.getValue((VariableContainer)execution);
                if (variableNameValue != null) {
                    variableName = variableNameValue.toString();
                } else {
                    LOGGER.warn("In parameter target expression {} did not resolve to a variable name, this is most likely a programmatic error", (Object)inParameter.getTargetExpression());
                }
            } else if (StringUtils.isNotEmpty((CharSequence)inParameter.getTarget())) {
                variableName = inParameter.getTarget();
            }
            instanceBeforeContext.getVariables().put(variableName, value);
        }
        if (!instanceBeforeContext.getVariables().isEmpty()) {
            this.initializeVariables(subProcessInstance, instanceBeforeContext.getVariables());
        }
        String processInstanceName = null;
        if (StringUtils.isNotEmpty((CharSequence)instanceBeforeContext.getProcessInstanceName())) {
            Expression processInstanceNameExpression = expressionManager.createExpression(instanceBeforeContext.getProcessInstanceName());
            processInstanceName = processInstanceNameExpression.getValue((VariableContainer)subProcessInstance).toString();
            subProcessInstance.setName(processInstanceName);
        }
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, subProcessInstance), processEngineConfiguration.getEngineCfgKey());
        }
        if (processEngineConfiguration.isEnableEntityLinks()) {
            EntityLinkUtil.createEntityLinks(execution.getProcessInstanceId(), executionEntity.getId(), callActivity.getId(), subProcessInstance.getId(), "bpmn");
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getProcessInstanceIdVariableName()) && StringUtils.isNotEmpty((CharSequence)(idVariableName = (String)(expression = expressionManager.createExpression(callActivity.getProcessInstanceIdVariableName())).getValue((VariableContainer)execution)))) {
            execution.setVariable(idVariableName, subProcessInstance.getId());
        }
        ExecutionEntity subProcessInitialExecution = executionEntityManager.createChildExecution(subProcessInstance);
        subProcessInitialExecution.setCurrentFlowElement(instanceBeforeContext.getInitialFlowElement());
        if (processEngineConfiguration.getStartProcessInstanceInterceptor() != null) {
            StartSubProcessInstanceAfterContext instanceAfterContext = new StartSubProcessInstanceAfterContext(subProcessInstance, subProcessInitialExecution, instanceBeforeContext.getVariables(), instanceBeforeContext.getCallActivityExecution(), instanceBeforeContext.getInParameters(), instanceBeforeContext.getInitialFlowElement(), instanceBeforeContext.getProcess(), instanceBeforeContext.getProcessDefinition());
            processEngineConfiguration.getStartProcessInstanceInterceptor().afterStartSubProcessInstance(instanceAfterContext);
        }
        processEngineConfiguration.getActivityInstanceEntityManager().recordSubProcessInstanceStart(executionEntity, subProcessInstance);
        CommandContextUtil.getAgenda().planContinueProcessOperation(subProcessInitialExecution);
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createProcessStartedEvent(subProcessInitialExecution, instanceBeforeContext.getVariables(), false), processEngineConfiguration.getEngineCfgKey());
        }
    }

    protected ProcessDefinition getProcessDefinition(DelegateExecution execution, CallActivity callActivity, ProcessEngineConfigurationImpl processEngineConfiguration) {
        ProcessDefinition processDefinition;
        switch (StringUtils.isNotEmpty((CharSequence)this.calledElementType) ? this.calledElementType : CALLED_ELEMENT_TYPE_KEY) {
            case "id": {
                processDefinition = this.getProcessDefinitionById(execution, processEngineConfiguration);
                break;
            }
            case "key": {
                processDefinition = this.getProcessDefinitionByKey(execution, callActivity.isSameDeployment(), processEngineConfiguration);
                break;
            }
            default: {
                throw new FlowableException("Unrecognized calledElementType [" + this.calledElementType + "]");
            }
        }
        return processDefinition;
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager();
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CallActivity callActivity = (CallActivity)executionEntity.getCurrentFlowElement();
        for (IOParameter outParameter : callActivity.getOutParameters()) {
            Object value = null;
            if (StringUtils.isNotEmpty((CharSequence)outParameter.getSourceExpression())) {
                Expression expression = expressionManager.createExpression(outParameter.getSourceExpression().trim());
                value = expression.getValue((VariableContainer)subProcessInstance);
            } else {
                value = subProcessInstance.getVariable(outParameter.getSource());
            }
            String variableName = null;
            if (StringUtils.isNotEmpty((CharSequence)outParameter.getTarget())) {
                variableName = outParameter.getTarget();
            } else if (StringUtils.isNotEmpty((CharSequence)outParameter.getTargetExpression())) {
                Expression expression = expressionManager.createExpression(outParameter.getTargetExpression());
                Object variableNameValue = expression.getValue((VariableContainer)subProcessInstance);
                if (variableNameValue != null) {
                    variableName = variableNameValue.toString();
                } else {
                    LOGGER.warn("Out parameter target expression {} did not resolve to a variable name, this is most likely a programmatic error", (Object)outParameter.getTargetExpression());
                }
            }
            if (callActivity.isUseLocalScopeForOutParameters()) {
                execution.setVariableLocal(variableName, value);
                continue;
            }
            execution.setVariable(variableName, value);
        }
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
        this.leave(execution);
    }

    protected ProcessDefinition getProcessDefinitionById(DelegateExecution execution, ProcessEngineConfigurationImpl processEngineConfiguration) {
        return CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.getCalledElementValue(execution, processEngineConfiguration));
    }

    protected ProcessDefinition getProcessDefinitionByKey(DelegateExecution execution, boolean isSameDeployment, ProcessEngineConfigurationImpl processEngineConfiguration) {
        ProcessDefinitionEntity processDefinition;
        String processDefinitionKey = this.getCalledElementValue(execution, processEngineConfiguration);
        String tenantId = execution.getTenantId();
        ProcessDefinitionEntityManager processDefinitionEntityManager = Context.getProcessEngineConfiguration().getProcessDefinitionEntityManager();
        if (isSameDeployment) {
            String deploymentId = ProcessDefinitionUtil.getProcessDefinition(execution.getProcessDefinitionId()).getDeploymentId();
            processDefinition = tenantId == null || "".equals(tenantId) ? processDefinitionEntityManager.findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey) : processDefinitionEntityManager.findProcessDefinitionByDeploymentAndKeyAndTenantId(deploymentId, processDefinitionKey, tenantId);
            if (processDefinition != null) {
                return processDefinition;
            }
        }
        if (tenantId == null || "".equals(tenantId)) {
            processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKey(processDefinitionKey);
        } else {
            processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
            if (processDefinition == null && (this.fallbackToDefaultTenant != null && this.fallbackToDefaultTenant.booleanValue() || processEngineConfiguration.isFallbackToDefaultTenant())) {
                String defaultTenant = processEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(tenantId, "bpmn", processDefinitionKey);
                processDefinition = StringUtils.isNotEmpty((CharSequence)defaultTenant) ? processDefinitionEntityManager.findLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, defaultTenant) : processDefinitionEntityManager.findLatestProcessDefinitionByKey(processDefinitionKey);
            }
        }
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("Process definition " + processDefinitionKey + " was not found in sameDeployment[" + isSameDeployment + "] tenantId[" + tenantId + "] fallbackToDefaultTenant[" + this.fallbackToDefaultTenant + "]");
        }
        return processDefinition;
    }

    protected String getCalledElementValue(DelegateExecution execution, ProcessEngineConfigurationImpl processEngineConfiguration) {
        String calledElementValue = this.callActivity.getCalledElement();
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.callActivity.getId(), execution.getProcessDefinitionId());
            calledElementValue = DynamicPropertyUtil.getActiveValue(this.callActivity.getCalledElement(), "callActivityCalledElement", taskElementProperties);
        }
        if (StringUtils.isNotEmpty((CharSequence)calledElementValue) && calledElementValue.matches(EXPRESSION_REGEX)) {
            calledElementValue = (String)processEngineConfiguration.getExpressionManager().createExpression(calledElementValue).getValue((VariableContainer)execution);
        }
        return calledElementValue;
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            variablesMap = new HashMap(dataObjects.size());
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    protected void initializeVariables(ExecutionEntity subProcessInstance, Map<String, Object> variables) {
        subProcessInstance.setVariables(variables);
    }
}

