/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.repository.InternalProcessDefinitionLocalizationManager;
import org.flowable.engine.repository.ProcessDefinition;

public class DefaultProcessDefinitionLocalizationManager
implements InternalProcessDefinitionLocalizationManager {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultProcessDefinitionLocalizationManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public void localize(ProcessDefinition processDefinition, String locale, boolean withLocalizationFallback) {
        ObjectNode languageNode;
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)processDefinition;
        processDefinitionEntity.setLocalizedName(null);
        processDefinitionEntity.setLocalizedDescription(null);
        if (locale != null && (languageNode = BpmnOverrideContext.getLocalizationElementProperties(locale, processDefinitionEntity.getKey(), processDefinition.getId(), withLocalizationFallback)) != null) {
            JsonNode languageDescriptionNode;
            JsonNode languageNameNode = languageNode.get("name");
            if (languageNameNode != null && !languageNameNode.isNull()) {
                processDefinitionEntity.setLocalizedName(languageNameNode.asText());
            }
            if ((languageDescriptionNode = languageNode.get("description")) != null && !languageDescriptionNode.isNull()) {
                processDefinitionEntity.setLocalizedDescription(languageDescriptionNode.asText());
            }
        }
    }
}

