/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.engine.impl.persistence.entity.CommentEntity;
import org.flowable.engine.impl.persistence.entity.CommentEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.data.CommentDataManager;
import org.flowable.engine.task.Comment;
import org.flowable.engine.task.Event;

public class CommentEntityManagerImpl
extends AbstractEntityManager<CommentEntity>
implements CommentEntityManager {
    protected CommentDataManager commentDataManager;

    public CommentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, CommentDataManager commentDataManager) {
        super(processEngineConfiguration);
        this.commentDataManager = commentDataManager;
    }

    @Override
    protected DataManager<CommentEntity> getDataManager() {
        return this.commentDataManager;
    }

    @Override
    public void insert(CommentEntity commentEntity) {
        this.checkHistoryEnabled();
        this.insert(commentEntity, false);
        CommentEntity comment = commentEntity;
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = comment.getProcessInstanceId();
            if (comment.getProcessInstanceId() != null && (process = (ExecutionEntity)this.getExecutionEntityManager().findById(comment.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, commentEntity, processInstanceId, processInstanceId, processDefinitionId));
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, commentEntity, processInstanceId, processInstanceId, processDefinitionId));
        }
    }

    @Override
    public CommentEntity update(CommentEntity commentEntity) {
        this.checkHistoryEnabled();
        CommentEntity updatedCommentEntity = this.update(commentEntity, false);
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = updatedCommentEntity.getProcessInstanceId();
            if (updatedCommentEntity.getProcessInstanceId() != null && (process = (ExecutionEntity)this.getExecutionEntityManager().findById(updatedCommentEntity.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, commentEntity, processInstanceId, processInstanceId, processDefinitionId));
        }
        return updatedCommentEntity;
    }

    @Override
    public List<Comment> findCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.commentDataManager.findCommentsByTaskId(taskId);
    }

    @Override
    public List<Comment> findCommentsByTaskIdAndType(String taskId, String type) {
        this.checkHistoryEnabled();
        return this.commentDataManager.findCommentsByTaskIdAndType(taskId, type);
    }

    @Override
    public List<Comment> findCommentsByType(String type) {
        this.checkHistoryEnabled();
        return this.commentDataManager.findCommentsByType(type);
    }

    @Override
    public List<Event> findEventsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.commentDataManager.findEventsByTaskId(taskId);
    }

    @Override
    public List<Event> findEventsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.commentDataManager.findEventsByProcessInstanceId(processInstanceId);
    }

    @Override
    public void deleteCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        this.commentDataManager.deleteCommentsByTaskId(taskId);
    }

    @Override
    public void deleteCommentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        this.commentDataManager.deleteCommentsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.commentDataManager.findCommentsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId, String type) {
        this.checkHistoryEnabled();
        return this.commentDataManager.findCommentsByProcessInstanceId(processInstanceId, type);
    }

    @Override
    public Comment findComment(String commentId) {
        return this.commentDataManager.findComment(commentId);
    }

    @Override
    public Event findEvent(String commentId) {
        return this.commentDataManager.findEvent(commentId);
    }

    @Override
    public void delete(CommentEntity commentEntity) {
        this.checkHistoryEnabled();
        this.delete(commentEntity, false);
        CommentEntity comment = commentEntity;
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = comment.getProcessInstanceId();
            if (comment.getProcessInstanceId() != null && (process = (ExecutionEntity)this.getExecutionEntityManager().findById(comment.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, commentEntity, processInstanceId, processInstanceId, processDefinitionId));
        }
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new FlowableException("In order to use comments, history should be enabled");
        }
    }

    public CommentDataManager getCommentDataManager() {
        return this.commentDataManager;
    }

    public void setCommentDataManager(CommentDataManager commentDataManager) {
        this.commentDataManager = commentDataManager;
    }
}

