/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsTaskHistoryJsonTransformer;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class TaskOwnerChangedHistoryJsonTransformer
extends AbstractNeedsTaskHistoryJsonTransformer {
    public List<String> getTypes() {
        return Collections.singletonList("task-owner-changed");
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String owner = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"owner");
        String taskId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id");
        HistoricIdentityLinkService historicIdentityLinkService = CommandContextUtil.getHistoricIdentityLinkService();
        HistoricIdentityLinkEntity historicIdentityLinkEntity = historicIdentityLinkService.createHistoricIdentityLink();
        historicIdentityLinkEntity.setTaskId(taskId);
        historicIdentityLinkEntity.setType("owner");
        historicIdentityLinkEntity.setUserId(owner);
        historicIdentityLinkEntity.setCreateTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"createTime"));
        historicIdentityLinkService.insertHistoricIdentityLink(historicIdentityLinkEntity, false);
    }
}

