/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.handler;

import java.util.Collection;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Message;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;

public class StartEventParseHandler
extends AbstractActivityBpmnParseHandler<StartEvent> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return StartEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, StartEvent element) {
        EventDefinition eventDefinition;
        if (element.getSubProcess() != null && element.getSubProcess() instanceof EventSubProcess) {
            if (CollectionUtil.isNotEmpty((Collection)element.getEventDefinitions())) {
                EventDefinition eventDefinition2 = (EventDefinition)element.getEventDefinitions().get(0);
                if (eventDefinition2 instanceof MessageEventDefinition) {
                    MessageEventDefinition messageDefinition = this.fillMessageRef(bpmnParse, eventDefinition2);
                    element.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createEventSubProcessMessageStartEventActivityBehavior(element, messageDefinition));
                } else if (eventDefinition2 instanceof SignalEventDefinition) {
                    SignalEventDefinition signalDefinition = (SignalEventDefinition)eventDefinition2;
                    Signal signal = null;
                    if (bpmnParse.getBpmnModel().containsSignalId(signalDefinition.getSignalRef())) {
                        signal = bpmnParse.getBpmnModel().getSignal(signalDefinition.getSignalRef());
                    }
                    element.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createEventSubProcessSignalStartEventActivityBehavior(element, signalDefinition, signal));
                } else if (eventDefinition2 instanceof TimerEventDefinition) {
                    TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition2;
                    element.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createEventSubProcessTimerStartEventActivityBehavior(element, timerEventDefinition));
                } else if (eventDefinition2 instanceof ErrorEventDefinition) {
                    element.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createEventSubProcessErrorStartEventActivityBehavior(element));
                } else if (eventDefinition2 instanceof EscalationEventDefinition) {
                    element.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createEventSubProcessEscalationStartEventActivityBehavior(element));
                }
            }
        } else if (CollectionUtil.isEmpty((Collection)element.getEventDefinitions())) {
            element.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createNoneStartEventActivityBehavior(element));
        } else if (CollectionUtil.isNotEmpty((Collection)element.getEventDefinitions()) && (eventDefinition = (EventDefinition)element.getEventDefinitions().get(0)) instanceof MessageEventDefinition) {
            this.fillMessageRef(bpmnParse, eventDefinition);
        }
        if (element.getSubProcess() == null && (CollectionUtil.isEmpty((Collection)element.getEventDefinitions()) || bpmnParse.getCurrentProcess().getInitialFlowElement() == null)) {
            bpmnParse.getCurrentProcess().setInitialFlowElement((FlowElement)element);
        }
    }

    protected MessageEventDefinition fillMessageRef(BpmnParse bpmnParse, EventDefinition eventDefinition) {
        String messageRef;
        MessageEventDefinition messageDefinition = (MessageEventDefinition)eventDefinition;
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        if (bpmnModel.containsMessageId(messageRef = messageDefinition.getMessageRef())) {
            Message message = bpmnModel.getMessage(messageRef);
            messageDefinition.setMessageRef(message.getName());
            messageDefinition.setExtensionElements(message.getExtensionElements());
        }
        return messageDefinition;
    }
}

