/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.migration;

import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.impl.migration.ProcessInstanceMigrationDocumentImpl;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationDocumentBuilder;

public class ProcessInstanceMigrationDocumentBuilderImpl
implements ProcessInstanceMigrationDocumentBuilder {
    protected String migrateToProcessDefinitionId;
    protected String migrateToProcessDefinitionKey;
    protected int migrateToProcessDefinitionVersion;
    protected String migrateToProcessDefinitionTenantId;
    protected Map<String, String> activityMigrationMappings = new LinkedHashMap<String, String>();

    @Override
    public ProcessInstanceMigrationDocumentBuilder setProcessDefinitionToMigrateTo(String processDefinitionId) {
        this.migrateToProcessDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder setProcessDefinitionToMigrateTo(String processDefinitionKey, int processDefinitionVersion) {
        this.migrateToProcessDefinitionKey = processDefinitionKey;
        this.migrateToProcessDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder setTenantId(String processDefinitionTenantId) {
        this.migrateToProcessDefinitionTenantId = processDefinitionTenantId;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder addActivityMigrationMappings(Map<String, String> activityMigrationMappings) {
        this.activityMigrationMappings.putAll(activityMigrationMappings);
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder addActivityMigrationMapping(String fromActivityId, String toActivityId) {
        if (fromActivityId == null) {
            throw new FlowableException("From process activity id mapping cannot be null");
        }
        if (toActivityId == null) {
            throw new FlowableException("To process activity id mapping cannot be null");
        }
        this.activityMigrationMappings.put(fromActivityId, toActivityId);
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocument build() {
        if (this.migrateToProcessDefinitionId == null) {
            if (this.migrateToProcessDefinitionKey == null) {
                throw new FlowableException("Process definition key cannot be null");
            }
            if (this.migrateToProcessDefinitionVersion < 0) {
                throw new FlowableException("Process definition version must be a positive number");
            }
        }
        ProcessInstanceMigrationDocumentImpl document = new ProcessInstanceMigrationDocumentImpl();
        document.setMigrateToProcessDefinitionId(this.migrateToProcessDefinitionId);
        document.setMigrateToProcessDefinition(this.migrateToProcessDefinitionKey, this.migrateToProcessDefinitionVersion, this.migrateToProcessDefinitionTenantId);
        document.setActivityMigrationMappings(this.activityMigrationMappings);
        return document;
    }
}

