/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.dynamic;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.dynamic.DynamicStateManager;
import org.flowable.engine.impl.dynamic.AbstractDynamicStateManager;
import org.flowable.engine.impl.dynamic.MoveExecutionEntityContainer;
import org.flowable.engine.impl.dynamic.ProcessInstanceChangeState;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.runtime.ChangeActivityStateBuilderImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.Execution;

public class DefaultDynamicStateManager
extends AbstractDynamicStateManager
implements DynamicStateManager {
    @Override
    public void moveExecutionState(ChangeActivityStateBuilderImpl changeActivityStateBuilder, CommandContext commandContext) {
        List<MoveExecutionEntityContainer> moveExecutionEntityContainerList = this.resolveMoveExecutionEntityContainers(changeActivityStateBuilder, Optional.empty(), commandContext);
        List<ExecutionEntity> executions = moveExecutionEntityContainerList.iterator().next().getExecutions();
        String processInstanceId = executions.iterator().next().getProcessInstanceId();
        ProcessInstanceChangeState processInstanceChangeState = new ProcessInstanceChangeState().setProcessInstanceId(processInstanceId).setMoveExecutionEntityContainers(moveExecutionEntityContainerList).setLocalVariables(changeActivityStateBuilder.getLocalVariables()).setProcessInstanceVariables(changeActivityStateBuilder.getProcessInstanceVariables());
        this.doMoveExecutionState(processInstanceChangeState, commandContext);
    }

    @Override
    protected Map<String, List<ExecutionEntity>> resolveActiveEmbeddedSubProcesses(String processInstanceId, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceId);
        Map<String, List<ExecutionEntity>> activeSubProcessesByActivityId = childExecutions.stream().filter(DelegateExecution::isActive).filter(executionEntity -> executionEntity.getCurrentFlowElement() instanceof SubProcess).collect(Collectors.groupingBy(Execution::getActivityId));
        return activeSubProcessesByActivityId;
    }

    @Override
    protected boolean isDirectFlowElementExecutionMigration(FlowElement currentFlowElement, FlowElement newFlowElement) {
        return false;
    }
}

