/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class GetIdentityLinksForTaskCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetIdentityLinksForTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    public List<IdentityLink> execute(CommandContext commandContext) {
        IdentityLinkEntity identityLink;
        TaskEntity task = CommandContextUtil.getTaskService().getTask(this.taskId);
        List identityLinks = task.getIdentityLinks();
        if (task.getAssignee() != null) {
            identityLink = CommandContextUtil.getIdentityLinkService().createIdentityLink();
            identityLink.setUserId(task.getAssignee());
            identityLink.setType("assignee");
            identityLink.setTaskId(task.getId());
            identityLinks.add(identityLink);
        }
        if (task.getOwner() != null) {
            identityLink = CommandContextUtil.getIdentityLinkService().createIdentityLink();
            identityLink.setUserId(task.getOwner());
            identityLink.setTaskId(task.getId());
            identityLink.setType("owner");
            identityLinks.add(identityLink);
        }
        return identityLinks;
    }
}

