/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.IdentityLinkUtil;
import org.flowable.identitylink.service.event.impl.FlowableIdentityLinkEventBuilder;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.event.impl.FlowableVariableEventBuilder;
import org.flowable.variable.service.impl.persistence.entity.VariableByteArrayRef;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class TaskHelper {
    public static void completeTask(TaskEntity taskEntity, Map<String, Object> variables, Map<String, Object> transientVariables, boolean localScope, CommandContext commandContext) {
        FlowableEventDispatcher eventDispatcher;
        if (taskEntity.getDelegationState() != null && taskEntity.getDelegationState() == DelegationState.PENDING) {
            throw new FlowableException("A delegated task cannot be completed, but should be resolved instead.");
        }
        if (variables != null) {
            if (localScope) {
                taskEntity.setVariablesLocal(variables);
            } else if (taskEntity.getExecutionId() != null) {
                ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getExecutionId());
                if (execution != null) {
                    execution.setVariables(variables);
                }
            } else {
                taskEntity.setVariables(variables);
            }
        }
        if (transientVariables != null) {
            if (localScope) {
                taskEntity.setTransientVariablesLocal(transientVariables);
            } else {
                taskEntity.setTransientVariables(transientVariables);
            }
        }
        CommandContextUtil.getProcessEngineConfiguration(commandContext).getListenerNotificationHelper().executeTaskListeners(taskEntity, "complete");
        if (Authentication.getAuthenticatedUserId() != null && taskEntity.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(taskEntity.getProcessInstanceId());
            IdentityLinkUtil.createProcessInstanceIdentityLink(processInstanceEntity, Authentication.getAuthenticatedUserId(), null, "participant");
        }
        if ((eventDispatcher = CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher()).isEnabled()) {
            if (variables != null) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityWithVariablesEvent(FlowableEngineEventType.TASK_COMPLETED, taskEntity, variables, localScope));
            } else {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_COMPLETED, taskEntity));
            }
        }
        TaskHelper.deleteTask(taskEntity, null, false, true, true);
        if (taskEntity.getExecutionId() != null) {
            ExecutionEntity executionEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(taskEntity.getExecutionId());
            CommandContextUtil.getAgenda(commandContext).planTriggerExecutionOperation(executionEntity);
        }
    }

    public static void changeTaskAssignee(TaskEntity taskEntity, String assignee) {
        if (taskEntity.getAssignee() != null && !taskEntity.getAssignee().equals(assignee) || taskEntity.getAssignee() == null && assignee != null) {
            CommandContextUtil.getTaskService().changeTaskAssignee(taskEntity, assignee);
            TaskHelper.fireAssignmentEvents(taskEntity);
            if (taskEntity.getId() != null) {
                TaskHelper.addAssigneeIdentityLinks(taskEntity);
            }
        }
    }

    public static void changeTaskOwner(TaskEntity taskEntity, String owner) {
        if (taskEntity.getOwner() != null && !taskEntity.getOwner().equals(owner) || taskEntity.getOwner() == null && owner != null) {
            CommandContextUtil.getTaskService().changeTaskOwner(taskEntity, owner);
            if (taskEntity.getId() != null) {
                TaskHelper.addOwnerIdentityLink(taskEntity, taskEntity.getOwner());
            }
        }
    }

    public static void insertTask(TaskEntity taskEntity, ExecutionEntity execution, boolean fireCreateEvent) {
        if (execution != null && execution.getTenantId() != null) {
            taskEntity.setTenantId(execution.getTenantId());
        }
        if (execution != null) {
            execution.getTasks().add(taskEntity);
            taskEntity.setExecutionId(execution.getId());
            taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
            taskEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        }
        TaskHelper.insertTask(taskEntity, fireCreateEvent);
        if (execution != null && CountingEntityUtil.isExecutionRelatedEntityCountEnabled(execution)) {
            CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)execution);
            countingExecutionEntity.setTaskCount(countingExecutionEntity.getTaskCount() + 1);
        }
        if (fireCreateEvent && CommandContextUtil.getEventDispatcher().isEnabled() && taskEntity.getAssignee() != null) {
            CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, taskEntity));
        }
        CommandContextUtil.getHistoryManager().recordTaskCreated(taskEntity, execution);
    }

    public static void insertTask(TaskEntity taskEntity, boolean fireCreateEvent) {
        if (taskEntity.getOwner() != null) {
            TaskHelper.addOwnerIdentityLink(taskEntity, taskEntity.getOwner());
        }
        if (taskEntity.getAssignee() != null) {
            TaskHelper.addAssigneeIdentityLinks(taskEntity);
        }
        CommandContextUtil.getTaskService().insertTask(taskEntity, fireCreateEvent);
    }

    public static void addAssigneeIdentityLinks(TaskEntity taskEntity) {
        if (taskEntity.getAssignee() != null && taskEntity.getProcessInstanceId() != null) {
            ExecutionEntity processInstance = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getProcessInstanceId());
            IdentityLinkUtil.createProcessInstanceIdentityLink(processInstance, taskEntity.getAssignee(), null, "participant");
        }
    }

    public static void addOwnerIdentityLink(TaskEntity taskEntity, String owner) {
        if (owner == null && taskEntity.getOwner() == null) {
            return;
        }
        if (owner != null && taskEntity.getProcessInstanceId() != null) {
            ExecutionEntity processInstance = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getProcessInstanceId());
            IdentityLinkUtil.createProcessInstanceIdentityLink(processInstance, owner, null, "participant");
        }
    }

    public static void deleteTasksForExecution(ExecutionEntity executionEntity, Collection<TaskEntity> taskEntities, String deleteReason) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        for (TaskEntity taskEntity : taskEntities) {
            TaskHelper.internalDeleteTask(taskEntity, deleteReason, false, false, true, true);
        }
        CommandContextUtil.getTaskService(commandContext).deleteTasksByExecutionId(executionEntity.getId());
    }

    public static void deleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean fireTaskListener, boolean fireEvents) {
        TaskHelper.internalDeleteTask(task, deleteReason, cascade, true, fireTaskListener, fireEvents);
    }

    protected static void internalDeleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean executeTaskDelete, boolean fireTaskListener, boolean fireEvents) {
        if (!task.isDeleted()) {
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher();
            boolean bl = fireEvents = fireEvents && eventDispatcher != null && eventDispatcher.isEnabled();
            if (fireTaskListener) {
                CommandContextUtil.getProcessEngineConfiguration(commandContext).getListenerNotificationHelper().executeTaskListeners(task, "delete");
            }
            task.setDeleted(true);
            TaskHelper.handleRelatedEntities(commandContext, task, deleteReason, cascade, fireTaskListener, fireEvents, eventDispatcher);
            TaskHelper.handleTaskHistory(commandContext, task, deleteReason, cascade);
            if (executeTaskDelete) {
                TaskHelper.executeTaskDelete(task, commandContext);
            }
            if (fireEvents) {
                TaskHelper.fireTaskDeletedEvent(task, commandContext, eventDispatcher);
            }
        }
    }

    protected static void handleRelatedEntities(CommandContext commandContext, TaskEntity task, String deleteReason, boolean cascade, boolean fireTaskListener, boolean fireEvents, FlowableEventDispatcher eventDispatcher) {
        boolean isTaskRelatedEntityCountEnabled = CountingEntityUtil.isTaskRelatedEntityCountEnabled(task);
        if (!isTaskRelatedEntityCountEnabled || isTaskRelatedEntityCountEnabled && ((CountingTaskEntity)task).getSubTaskCount() > 0) {
            TaskService taskService = CommandContextUtil.getTaskService(commandContext);
            List subTasks = taskService.findTasksByParentTaskId(task.getId());
            for (Task subTask : subTasks) {
                TaskHelper.internalDeleteTask((TaskEntity)subTask, deleteReason, cascade, true, fireTaskListener, fireEvents);
            }
        }
        if (!isTaskRelatedEntityCountEnabled || isTaskRelatedEntityCountEnabled && ((CountingTaskEntity)task).getIdentityLinkCount() > 0) {
            boolean deleteIdentityLinks = true;
            if (fireEvents) {
                List identityLinks = CommandContextUtil.getIdentityLinkService(commandContext).findIdentityLinksByTaskId(task.getId());
                for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableIdentityLinkEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.ENTITY_DELETED, (Object)identityLinkEntity));
                }
                boolean bl = deleteIdentityLinks = !identityLinks.isEmpty();
            }
            if (deleteIdentityLinks) {
                CommandContextUtil.getIdentityLinkService(commandContext).deleteIdentityLinksByTaskId(task.getId());
            }
        }
        if (!isTaskRelatedEntityCountEnabled || isTaskRelatedEntityCountEnabled && ((CountingTaskEntity)task).getVariableCount() > 0) {
            Map taskVariables = task.getVariableInstanceEntities();
            ArrayList<VariableByteArrayRef> variableByteArrayRefs = new ArrayList<VariableByteArrayRef>();
            for (VariableInstanceEntity variableInstanceEntity : taskVariables.values()) {
                if (fireEvents) {
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.ENTITY_DELETED, (Object)variableInstanceEntity));
                }
                if (variableInstanceEntity.getByteArrayRef() == null || variableInstanceEntity.getByteArrayRef().getId() == null) continue;
                variableByteArrayRefs.add(variableInstanceEntity.getByteArrayRef());
            }
            for (VariableByteArrayRef variableByteArrayRef : variableByteArrayRefs) {
                CommandContextUtil.getByteArrayEntityManager(commandContext).deleteByteArrayById(variableByteArrayRef.getId());
            }
            if (!taskVariables.isEmpty()) {
                CommandContextUtil.getVariableService(commandContext).deleteVariablesByTaskId(task.getId());
            }
        }
    }

    protected static void handleTaskHistory(CommandContext commandContext, TaskEntity task, String deleteReason, boolean cascade) {
        if (cascade) {
            TaskHelper.deleteHistoricTask(task.getId());
        } else {
            ExecutionEntity execution = null;
            if (task.getExecutionId() != null) {
                execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(task.getExecutionId());
            }
            CommandContextUtil.getHistoryManager(commandContext).recordTaskEnd(task, execution, deleteReason);
        }
    }

    protected static void executeTaskDelete(TaskEntity task, CommandContext commandContext) {
        CountingExecutionEntity countingExecutionEntity;
        CommandContextUtil.getTaskService(commandContext).deleteTask(task, false);
        if (task.getExecutionId() != null && CountingEntityUtil.isExecutionRelatedEntityCountEnabledGlobally() && CountingEntityUtil.isExecutionRelatedEntityCountEnabled(countingExecutionEntity = (CountingExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(task.getExecutionId()))) {
            countingExecutionEntity.setTaskCount(countingExecutionEntity.getTaskCount() - 1);
        }
    }

    protected static void fireTaskDeletedEvent(TaskEntity task, CommandContext commandContext, FlowableEventDispatcher eventDispatcher) {
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            CommandContextUtil.getEventDispatcher(commandContext).dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, task));
        }
    }

    public static void deleteTask(String taskId, String deleteReason, boolean cascade) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        TaskEntity task = CommandContextUtil.getTaskService(commandContext).getTask(taskId);
        if (task != null) {
            if (task.getExecutionId() != null) {
                throw new FlowableException("The task cannot be deleted because is part of a running process");
            }
            if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.deleteTask(taskId, deleteReason, cascade);
                return;
            }
            TaskHelper.deleteTask(task, deleteReason, cascade, true, true);
        } else if (cascade) {
            TaskHelper.deleteHistoricTask(taskId);
        }
    }

    public static void deleteTasksByProcessInstanceId(String processInstanceId, String deleteReason, boolean cascade) {
        List tasks = CommandContextUtil.getTaskService().findTasksByProcessInstanceId(processInstanceId);
        for (TaskEntity task : tasks) {
            if (CommandContextUtil.getEventDispatcher().isEnabled() && !task.isCanceled()) {
                task.setCanceled(true);
                ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(task.getExecutionId());
                CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(execution.getActivityId(), task.getName(), task.getExecutionId(), task.getProcessInstanceId(), task.getProcessDefinitionId(), "userTask", deleteReason));
            }
            TaskHelper.deleteTask(task, deleteReason, cascade, true, true);
        }
    }

    public static void deleteHistoricTaskInstancesByProcessInstanceId(String processInstanceId) {
        if (CommandContextUtil.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricTaskService historicTaskService = CommandContextUtil.getHistoricTaskService();
            List taskInstances = historicTaskService.findHistoricTasksByProcessInstanceId(processInstanceId);
            for (HistoricTaskInstanceEntity historicTaskInstanceEntity : taskInstances) {
                TaskHelper.deleteHistoricTask(historicTaskInstanceEntity.getId());
            }
        }
    }

    public static void deleteHistoricTask(String taskId) {
        if (CommandContextUtil.getHistoryManager().isHistoryEnabled()) {
            CommandContextUtil.getCommentEntityManager().deleteCommentsByTaskId(taskId);
            CommandContextUtil.getAttachmentEntityManager().deleteAttachmentsByTaskId(taskId);
            HistoricTaskService historicTaskService = CommandContextUtil.getHistoricTaskService();
            HistoricTaskInstanceEntity historicTaskInstance = historicTaskService.getHistoricTask(taskId);
            if (historicTaskInstance != null) {
                if (historicTaskInstance.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(CommandContextUtil.getCommandContext(), historicTaskInstance.getProcessDefinitionId())) {
                    Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                    compatibilityHandler.deleteHistoricTask(taskId);
                    return;
                }
                List subTasks = historicTaskService.findHistoricTasksByParentTaskId(historicTaskInstance.getId());
                for (HistoricTaskInstance subTask : subTasks) {
                    TaskHelper.deleteHistoricTask(subTask.getId());
                }
                CommandContextUtil.getHistoricDetailEntityManager().deleteHistoricDetailsByTaskId(taskId);
                CommandContextUtil.getHistoricVariableService().deleteHistoricVariableInstancesByTaskId(taskId);
                CommandContextUtil.getHistoricIdentityLinkService().deleteHistoricIdentityLinksByTaskId(taskId);
                historicTaskService.deleteHistoricTask(historicTaskInstance);
            }
        }
    }

    protected static void fireAssignmentEvents(TaskEntity taskEntity) {
        CommandContextUtil.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(taskEntity, "assignment");
        if (CommandContextUtil.getEventDispatcher().isEnabled()) {
            CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, taskEntity));
        }
    }
}

