/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.ArrayList;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.dynamic.DynamicStateManager;
import org.flowable.engine.impl.dynamic.MoveExecutionEntityContainer;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.runtime.ChangeActivityStateBuilderImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ChangeActivityStateCmd
implements Command<Void> {
    protected ChangeActivityStateBuilderImpl changeActivityStateBuilder;

    public ChangeActivityStateCmd(ChangeActivityStateBuilderImpl changeActivityStateBuilder) {
        this.changeActivityStateBuilder = changeActivityStateBuilder;
    }

    public Void execute(CommandContext commandContext) {
        ExecutionEntity execution;
        ArrayList<ExecutionEntity> executions;
        if (this.changeActivityStateBuilder.getMoveExecutionIdList().size() == 0 && this.changeActivityStateBuilder.getMoveActivityIdList().size() == 0) {
            throw new FlowableIllegalArgumentException("No move execution or activity ids provided");
        }
        if (this.changeActivityStateBuilder.getMoveActivityIdList().size() > 0 && this.changeActivityStateBuilder.getProcessInstanceId() == null) {
            throw new FlowableIllegalArgumentException("Process instance id is required");
        }
        DynamicStateManager dynamicStateManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDynamicStateManager();
        ArrayList<MoveExecutionEntityContainer> moveExecutionEntityContainerList = new ArrayList<MoveExecutionEntityContainer>();
        if (this.changeActivityStateBuilder.getMoveExecutionIdList().size() > 0) {
            for (ChangeActivityStateBuilderImpl.MoveExecutionIdContainer executionContainer : this.changeActivityStateBuilder.getMoveExecutionIdList()) {
                executions = new ArrayList<ExecutionEntity>();
                for (String executionId : executionContainer.getExecutionIds()) {
                    execution = dynamicStateManager.resolveActiveExecution(executionId, commandContext);
                    executions.add(execution);
                }
                moveExecutionEntityContainerList.add(new MoveExecutionEntityContainer(executions, executionContainer.getMoveToActivityIds()));
            }
        }
        if (this.changeActivityStateBuilder.getMoveActivityIdList().size() > 0) {
            for (ChangeActivityStateBuilderImpl.MoveActivityIdContainer activityContainer : this.changeActivityStateBuilder.getMoveActivityIdList()) {
                executions = new ArrayList();
                for (String activityId : activityContainer.getActivityIds()) {
                    execution = dynamicStateManager.resolveActiveExecution(this.changeActivityStateBuilder.getProcessInstanceId(), activityId, commandContext);
                    executions.add(execution);
                }
                MoveExecutionEntityContainer moveExecutionEntityContainer = new MoveExecutionEntityContainer(executions, activityContainer.getMoveToActivityIds());
                if (activityContainer.isMoveToParentProcess()) {
                    ExecutionEntity processInstanceExecution = ((ExecutionEntity)executions.get(0)).getProcessInstance();
                    ExecutionEntity superExecution = processInstanceExecution.getSuperExecution();
                    if (superExecution == null) {
                        throw new FlowableException("No parent process found for execution with activity id " + ((ExecutionEntity)executions.get(0)).getCurrentActivityId());
                    }
                    moveExecutionEntityContainer.setMoveToParentProcess(true);
                    moveExecutionEntityContainer.setSuperExecution(superExecution);
                } else if (activityContainer.isMoveToSubProcessInstance()) {
                    moveExecutionEntityContainer.setMoveToSubProcessInstance(true);
                    moveExecutionEntityContainer.setCallActivityId(activityContainer.getCallActivityId());
                }
                moveExecutionEntityContainerList.add(moveExecutionEntityContainer);
            }
        }
        dynamicStateManager.moveExecutionState(moveExecutionEntityContainerList, this.changeActivityStateBuilder.getProcessVariables(), this.changeActivityStateBuilder.getLocalVariables(), commandContext);
        return null;
    }
}

