/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.EventUtil;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class CountingEntityUtil {
    public static void handleDeleteVariableInstanceEntityCount(VariableInstanceEntity variableInstance, boolean fireDeleteEvent) {
        CountingExecutionEntity executionEntity;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        if (variableInstance.getTaskId() != null && CountingEntityUtil.isTaskRelatedEntityCountEnabledGlobally()) {
            CountingTaskEntity countingTaskEntity = (CountingTaskEntity)CommandContextUtil.getTaskService().getTask(variableInstance.getTaskId());
            if (CountingEntityUtil.isTaskRelatedEntityCountEnabled(countingTaskEntity)) {
                countingTaskEntity.setVariableCount(countingTaskEntity.getVariableCount() - 1);
            }
        } else if (variableInstance.getExecutionId() != null && CountingEntityUtil.isExecutionRelatedEntityCountEnabledGlobally() && CountingEntityUtil.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(variableInstance.getExecutionId()))) {
            executionEntity.setVariableCount(executionEntity.getVariableCount() - 1);
        }
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher(commandContext);
        if (fireDeleteEvent && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, variableInstance));
            eventDispatcher.dispatchEvent((FlowableEvent)EventUtil.createVariableDeleteEvent(variableInstance));
        }
    }

    public static void handleInsertVariableInstanceEntityCount(VariableInstanceEntity variableInstance) {
        CountingExecutionEntity executionEntity;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        if (variableInstance.getTaskId() != null && CountingEntityUtil.isTaskRelatedEntityCountEnabledGlobally()) {
            CountingTaskEntity countingTaskEntity = (CountingTaskEntity)CommandContextUtil.getTaskService().getTask(variableInstance.getTaskId());
            if (CountingEntityUtil.isTaskRelatedEntityCountEnabled(countingTaskEntity)) {
                countingTaskEntity.setVariableCount(countingTaskEntity.getVariableCount() + 1);
            }
        } else if (variableInstance.getExecutionId() != null && CountingEntityUtil.isExecutionRelatedEntityCountEnabledGlobally() && CountingEntityUtil.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(variableInstance.getExecutionId()))) {
            executionEntity.setVariableCount(executionEntity.getVariableCount() + 1);
        }
    }

    public static boolean isExecutionRelatedEntityCountEnabledGlobally() {
        return CommandContextUtil.getProcessEngineConfiguration().getPerformanceSettings().isEnableExecutionRelationshipCounts();
    }

    public static boolean isTaskRelatedEntityCountEnabledGlobally() {
        return CommandContextUtil.getProcessEngineConfiguration().getPerformanceSettings().isEnableTaskRelationshipCounts();
    }

    public static boolean isExecutionRelatedEntityCountEnabled(ExecutionEntity executionEntity) {
        if (executionEntity.isProcessInstanceType() || executionEntity instanceof CountingExecutionEntity) {
            return CountingEntityUtil.isExecutionRelatedEntityCountEnabled((CountingExecutionEntity)((Object)executionEntity));
        }
        return false;
    }

    public static boolean isTaskRelatedEntityCountEnabled(TaskEntity taskEntity) {
        if (taskEntity instanceof CountingTaskEntity) {
            return CountingEntityUtil.isTaskRelatedEntityCountEnabled((CountingTaskEntity)taskEntity);
        }
        return false;
    }

    public static boolean isExecutionRelatedEntityCountEnabled(CountingExecutionEntity executionEntity) {
        return !executionEntity.isProcessInstanceType() && CountingEntityUtil.isExecutionRelatedEntityCountEnabledGlobally() && executionEntity.isCountEnabled();
    }

    public static boolean isTaskRelatedEntityCountEnabled(CountingTaskEntity taskEntity) {
        return CountingEntityUtil.isTaskRelatedEntityCountEnabledGlobally() && taskEntity.isCountEnabled();
    }
}

