/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.HistoricVariableService;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;

public class VariableCreatedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    @Override
    public String getType() {
        return "variable-created";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricVariableService historicVariableService = CommandContextUtil.getHistoricVariableService();
        HistoricVariableInstanceEntity historicVariableInstanceEntity = historicVariableService.createHistoricVariableInstance();
        historicVariableInstanceEntity.setId(this.getStringFromJson(historicalData, "id"));
        historicVariableInstanceEntity.setProcessInstanceId(this.getStringFromJson(historicalData, "processInstanceId"));
        historicVariableInstanceEntity.setExecutionId(this.getStringFromJson(historicalData, "executionId"));
        historicVariableInstanceEntity.setTaskId(this.getStringFromJson(historicalData, "taskId"));
        historicVariableInstanceEntity.setRevision(this.getIntegerFromJson(historicalData, "revision").intValue());
        historicVariableInstanceEntity.setName(this.getStringFromJson(historicalData, "name"));
        VariableTypes variableTypes = CommandContextUtil.getProcessEngineConfiguration().getVariableTypes();
        VariableType variableType = variableTypes.getVariableType(this.getStringFromJson(historicalData, "variableType"));
        historicVariableInstanceEntity.setVariableType(variableType);
        historicVariableInstanceEntity.setTextValue(this.getStringFromJson(historicalData, "variableTextValue"));
        historicVariableInstanceEntity.setTextValue2(this.getStringFromJson(historicalData, "variableTextValue2"));
        historicVariableInstanceEntity.setDoubleValue(this.getDoubleFromJson(historicalData, "variableDoubleValue"));
        historicVariableInstanceEntity.setLongValue(this.getLongFromJson(historicalData, "variableLongValue"));
        String variableBytes = this.getStringFromJson(historicalData, "variableBytesValue");
        if (StringUtils.isNotEmpty((CharSequence)variableBytes)) {
            historicVariableInstanceEntity.setBytes(Base64.getDecoder().decode(variableBytes));
        }
        Date time = this.getDateFromJson(historicalData, "createTime");
        historicVariableInstanceEntity.setCreateTime(time);
        historicVariableInstanceEntity.setLastUpdatedTime(time);
        historicVariableService.insertHistoricVariableInstance(historicVariableInstanceEntity);
    }
}

