/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsTaskHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;

public class TaskEndedHistoryJsonTransformer
extends AbstractNeedsTaskHistoryJsonTransformer {
    @Override
    public String getType() {
        return "task-ended";
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String taskId = this.getStringFromJson(historicalData, "id");
        HistoricTaskService historicTaskService = CommandContextUtil.getHistoricTaskService();
        HistoricTaskInstanceEntity historicTaskInstance = historicTaskService.getHistoricTask(taskId);
        if (historicTaskInstance != null) {
            Date lastUpdateTime = this.getDateFromJson(historicalData, "__timeStamp");
            if (historicTaskInstance.getLastUpdateTime() == null || !historicTaskInstance.getLastUpdateTime().after(lastUpdateTime)) {
                historicTaskInstance.setLastUpdateTime(lastUpdateTime);
                historicTaskInstance.setName(this.getStringFromJson(historicalData, "name"));
                historicTaskInstance.setParentTaskId(this.getStringFromJson(historicalData, "parentTaskId"));
                historicTaskInstance.setDescription(this.getStringFromJson(historicalData, "description"));
                historicTaskInstance.setOwner(this.getStringFromJson(historicalData, "owner"));
                historicTaskInstance.setAssignee(this.getStringFromJson(historicalData, "assignee"));
                historicTaskInstance.setStartTime(this.getDateFromJson(historicalData, "startTime"));
                historicTaskInstance.setTaskDefinitionKey(this.getStringFromJson(historicalData, "taskDefinitionKey"));
                historicTaskInstance.setTaskDefinitionId(this.getStringFromJson(historicalData, "taskDefinitionId"));
                historicTaskInstance.setPriority(this.getIntegerFromJson(historicalData, "priority").intValue());
                historicTaskInstance.setDueDate(this.getDateFromJson(historicalData, "dueDate"));
                historicTaskInstance.setCategory(this.getStringFromJson(historicalData, "category"));
                historicTaskInstance.setFormKey(this.getStringFromJson(historicalData, "formKey"));
                historicTaskInstance.setClaimTime(this.getDateFromJson(historicalData, "claimTime"));
                historicTaskInstance.setTenantId(this.getStringFromJson(historicalData, "tenantId"));
            }
            Date endTime = this.getDateFromJson(historicalData, "endTime");
            historicTaskInstance.setEndTime(endTime);
            historicTaskInstance.setDeleteReason(this.getStringFromJson(historicalData, "deleteReason"));
            Date startTime = historicTaskInstance.getStartTime();
            if (startTime != null && endTime != null) {
                historicTaskInstance.setDurationInMillis(Long.valueOf(endTime.getTime() - startTime.getTime()));
            }
        } else {
            HistoricActivityInstanceEntity historicActivityInstanceEntity;
            String activityId;
            String executionId = this.getStringFromJson(historicalData, "executionId");
            historicTaskInstance = historicTaskService.createHistoricTask();
            historicTaskInstance.setId(taskId);
            historicTaskInstance.setProcessDefinitionId(this.getStringFromJson(historicalData, "processDefinitionId"));
            historicTaskInstance.setProcessInstanceId(this.getStringFromJson(historicalData, "processInstanceId"));
            historicTaskInstance.setExecutionId(executionId);
            historicTaskInstance.setName(this.getStringFromJson(historicalData, "name"));
            historicTaskInstance.setParentTaskId(this.getStringFromJson(historicalData, "parentTaskId"));
            historicTaskInstance.setDescription(this.getStringFromJson(historicalData, "description"));
            historicTaskInstance.setOwner(this.getStringFromJson(historicalData, "owner"));
            historicTaskInstance.setAssignee(this.getStringFromJson(historicalData, "assignee"));
            historicTaskInstance.setStartTime(this.getDateFromJson(historicalData, "startTime"));
            historicTaskInstance.setTaskDefinitionKey(this.getStringFromJson(historicalData, "taskDefinitionKey"));
            historicTaskInstance.setTaskDefinitionId(this.getStringFromJson(historicalData, "taskDefinitionId"));
            historicTaskInstance.setPriority(this.getIntegerFromJson(historicalData, "priority").intValue());
            historicTaskInstance.setDueDate(this.getDateFromJson(historicalData, "dueDate"));
            historicTaskInstance.setCategory(this.getStringFromJson(historicalData, "category"));
            historicTaskInstance.setFormKey(this.getStringFromJson(historicalData, "formKey"));
            historicTaskInstance.setClaimTime(this.getDateFromJson(historicalData, "claimTime"));
            historicTaskInstance.setTenantId(this.getStringFromJson(historicalData, "tenantId"));
            historicTaskInstance.setLastUpdateTime(this.getDateFromJson(historicalData, "__timeStamp"));
            Date endTime = this.getDateFromJson(historicalData, "endTime");
            historicTaskInstance.setEndTime(endTime);
            historicTaskInstance.setDeleteReason(this.getStringFromJson(historicalData, "deleteReason"));
            Date startTime = historicTaskInstance.getStartTime();
            if (startTime != null && endTime != null) {
                historicTaskInstance.setDurationInMillis(Long.valueOf(endTime.getTime() - startTime.getTime()));
            }
            historicTaskService.insertHistoricTask(historicTaskInstance, true);
            if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)(activityId = this.getStringFromJson(historicalData, "activityId"))) && (historicActivityInstanceEntity = this.findHistoricActivityInstance(commandContext, executionId, activityId)) != null) {
                historicActivityInstanceEntity.setTaskId(taskId);
            }
        }
    }
}

